# """Test scripts for BSDGO1 Outlets."""
# from __future__ import annotations
# from typing import TYPE_CHECKING
# import orjson
# from pyvesync.devices.vesyncoutlet import VeSyncOutletBSDGO1
# from pyvesync.utils.helpers import Helpers as Helpers
# from pyvesync.models.vesync_models import ResponseDeviceDetailsModel
# from pyvesync.device_map import get_outlet
# import call_json
# import call_json_outlets
# from base_test_cases import TestBase
# from defaults import Defaults

# if TYPE_CHECKING:
#     from pyvesync.device_map import OutletMap

# DEVICE_TYPE = 'BSDOG01'
# if get_outlet(DEVICE_TYPE) is not None:
#     DEVICE_MAP = get_outlet(DEVICE_TYPE)

# DEV_LIST_DETAIL = call_json.DeviceList.device_list_item(DEVICE_MAP)

# CORRECT_BSDGO1_DETAILS = call_json_outlets.DETAILS_RESPONSES[DEVICE_TYPE]

# BAD_BSDGO1_LIST = call_json.DETAILS_BADCODE


# class TestVeSyncBSDGO1Switch(TestBase):
#     """Test BSDGO1 outlet API."""

#     def device_map(self) -> OutletMap:
#         outlet_map = get_outlet(DEVICE_TYPE)
#         if outlet_map is None:
#             raise ValueError(f'No device map found for {DEVICE_TYPE}')
#         return outlet_map

#     def device_list_model(self) -> ResponseDeviceDetailsModel:
#         return ResponseDeviceDetailsModel.from_dict(call_json.DeviceList.device_list_item(self.device_map()))

#     def test_bsdgo1_conf(self):
#         """Test initialization of BSDGO1 outlet."""
#         self.mock_api.return_value = call_json.DeviceList.device_list_response(DEVICE_TYPE)
#         self.run_in_loop(self.manager.get_devices)
#         outlets = self.manager.devices.outlets
#         assert len(outlets) == 1
#         bsdgo1_outlet = outlets[0]
#         assert isinstance(bsdgo1_outlet, VeSyncOutletBSDGO1)
#         assert bsdgo1_outlet.device_name == call_json.Defaults.name(DEVICE_TYPE)
#         assert bsdgo1_outlet.device_type == DEVICE_TYPE
#         assert bsdgo1_outlet.cid == call_json.Defaults.cid(DEVICE_TYPE)
#         assert bsdgo1_outlet.uuid == call_json.Defaults.uuid(DEVICE_TYPE)

#     def test_bsdgo1_details(self):
#         """Test BSDGO1 get_details()."""
#         resp_dict, status = self.device_list_model(), 200
#         self.mock_api.return_value = orjson.dumps(resp_dict), status

#         bsdgo1_outlet = VeSyncOutletBSDGO1(
#             self.device_list_model(),
#             self.manager,
#             self.device_map(),
#         )
#         self.run_in_loop(bsdgo1_outlet.get_details)
#         response = CORRECT_BSDGO1_DETAILS[0]
#         result = response.get('result', {})

#         expected_status = 'on' if result.get('powerSwitch_1') == 1 else 'off'
#         assert bsdgo1_outlet.state.device_status == expected_status

#         assert result.get('active_time') == Defaults.active_time
#         assert result.get('connectionStatus') == 'online'

#     def test_bsdgo1_details_fail(self):
#         """Test BSDGO1 get_details with bad response."""
#         resp_dict, status = BAD_BSDGO1_LIST
#         self.mock_api.return_value = orjson.dumps(resp_dict), status
#         bsdgo1_outlet = VeSyncOutletBSDGO1(
#             self.device_list_model(),
#             self.manager,
#             self.device_map(),
#         )
#         self.run_in_loop(bsdgo1_outlet.get_details)
#         assert len(self.caplog.records) == 1
#         assert 'details' in self.caplog.text

#     def test_bsdgo1_onoff(self):
#         """Test BSDGO1 Device On/Off Methods."""
#         self.mock_api.return_value = (orjson.dumps({'code': 0}), 200)
#         bsdgo1_outlet = VeSyncOutletBSDGO1(
#             self.device_list_model(),
#             self.manager,
#             self.device_map(),
#         )
#         head = Helpers.req_header_bypass()
#         body = Helpers.req_body(self.manager, 'bypassV2')
#         body['cid'] = bsdgo1_outlet.cid
#         body['configModule'] = bsdgo1_outlet.config_module

#         # Test turn_on
#         body['payload'] = {
#             'data': {'powerSwitch_1': 1},
#             'method': 'setProperty',
#             'source': 'APP'
#         }
#         on = self.run_in_loop(bsdgo1_outlet.turn_on)
#         self.mock_api.assert_called_with(
#             '/cloud/v2/deviceManaged/bypassV2',
#             'post',
#             headers=head,
#             json_object=body
#         )
#         assert on

#         # Test turn_off
#         body['payload'] = {
#             'data': {'powerSwitch_1': 0},
#             'method': 'setProperty',
#             'source': 'APP'
#         }
#         off = self.run_in_loop(bsdgo1_outlet.turn_off)
#         self.mock_api.assert_called_with(
#             '/cloud/v2/deviceManaged/bypassV2',
#             'post',
#             headers=head,
#             json_object=body
#         )
#         assert off

#     def test_bsdgo1_onoff_fail(self):
#         """Test BSDGO1 On/Off Fail with bad response."""
#         resp_dict, status = BAD_BSDGO1_LIST
#         self.mock_api.return_value = orjson.dumps(resp_dict), status
#         bsdgo1_outlet = VeSyncOutletBSDGO1(
#             self.device_list_model(),
#             self.manager,
#             self.device_map(),
#         )
#         assert not self.run_in_loop(bsdgo1_outlet.turn_on)
#         assert not self.run_in_loop(bsdgo1_outlet.turn_off)
