# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from devtools_testutils.aio import recorded_by_proxy_async
from testpreparer import AIProjectPreparer
from testpreparer_async import AIProjectClientTestBaseAsync


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestAIProjectDatasetsOperationsAsync(AIProjectClientTestBaseAsync):
    @AIProjectPreparer()
    @recorded_by_proxy_async
    async def test_datasets_list_versions(self, aiproject_endpoint):
        client = self.create_async_client(endpoint=aiproject_endpoint)
        response = client.datasets.list_versions(
            name="str",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @AIProjectPreparer()
    @recorded_by_proxy_async
    async def test_datasets_list(self, aiproject_endpoint):
        client = self.create_async_client(endpoint=aiproject_endpoint)
        response = client.datasets.list()
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @AIProjectPreparer()
    @recorded_by_proxy_async
    async def test_datasets_get(self, aiproject_endpoint):
        client = self.create_async_client(endpoint=aiproject_endpoint)
        response = await client.datasets.get(
            name="str",
            version="str",
        )

        # please add some check logic here by yourself
        # ...

    @AIProjectPreparer()
    @recorded_by_proxy_async
    async def test_datasets_delete(self, aiproject_endpoint):
        client = self.create_async_client(endpoint=aiproject_endpoint)
        response = await client.datasets.delete(
            name="str",
            version="str",
        )

        # please add some check logic here by yourself
        # ...

    @AIProjectPreparer()
    @recorded_by_proxy_async
    async def test_datasets_create_or_update(self, aiproject_endpoint):
        client = self.create_async_client(endpoint=aiproject_endpoint)
        response = await client.datasets.create_or_update(
            name="str",
            version="str",
            body={
                "dataUri": "str",
                "name": "str",
                "type": "uri_file",
                "version": "str",
                "connectionName": "str",
                "description": "str",
                "id": "str",
                "isReference": bool,
                "tags": {"str": "str"},
            },
        )

        # please add some check logic here by yourself
        # ...

    @AIProjectPreparer()
    @recorded_by_proxy_async
    async def test_datasets_pending_upload(self, aiproject_endpoint):
        client = self.create_async_client(endpoint=aiproject_endpoint)
        response = await client.datasets.pending_upload(
            name="str",
            version="str",
            body={"pendingUploadType": "str", "connectionName": "str", "pendingUploadId": "str"},
        )

        # please add some check logic here by yourself
        # ...

    @AIProjectPreparer()
    @recorded_by_proxy_async
    async def test_datasets_get_credentials(self, aiproject_endpoint):
        client = self.create_async_client(endpoint=aiproject_endpoint)
        response = await client.datasets.get_credentials(
            name="str",
            version="str",
        )

        # please add some check logic here by yourself
        # ...
