--TEST--
Regular Expression type: Regular expression as value of $regex query operator
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/basic.inc';

$canonicalBson = hex2bin('180000000B247265676578007061747465726E0069780000');
$canonicalExtJson = '{"$regex" : {"$regularExpression" : { "pattern": "pattern", "options" : "ix"}}}';

// Canonical BSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromBSON($canonicalBson)), "\n";

// Canonical BSON -> BSON object -> Canonical extJSON
echo json_canonicalize(MongoDB\BSON\Document::fromBSON($canonicalBson)->toCanonicalExtendedJSON()), "\n";

// Canonical extJSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromJSON($canonicalExtJson)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
180000000b247265676578007061747465726e0069780000
{"$regex":{"$regularExpression":{"pattern":"pattern","options":"ix"}}}
180000000b247265676578007061747465726e0069780000
===DONE===