#include <linux/module.h>
#include <linux/kernel.h>
#include <rtl_time.h>
#include <rtl_sched.h>
#include <asm/io.h>
#include <rtl.h>
#include <time.h>
#include "common.h"

int number_of_tests=50;
int period[2]={20000000,1000000};
int periodic_mode=0;

pthread_t T[2];
int shutdown = 0;

/* For testing purposes, if we are on a smp machine, try to 
  run the measurement module on the _other_cpu 
  on a uniprocessor, ignore this test.
*/
  
void *thread_code(void *t) {

	int i;
	int index = (int)t;
	printk("Multitask %x task starts\n",index);
	rtl_printf("Multitask %x task starts\n",index);
	rtl_printf("Multi task period %d\n",(int) period[index]);
	pthread_make_periodic_np(T[index], gethrtime(), period[index]);

	do {
		for(i=0; i < 1000; i++) pthread_wait_np();
		conpr("T");conpr((t== 0? "0\n":"1\n"));
	} while (!shutdown);
	return 0;
}



int init_module(void)
{
	pthread_attr_t attr;
	struct sched_param sched_param;
	int thread_status0 = 0;
	int thread_status1 = 0;

	printk("RTLinux multithread test  module on CPU %d\n",rtl_getcpuid());
	printk("WARNING: Output for this test is only visible on console\n");
	pthread_attr_init (&attr);
	sched_param.sched_priority = 1;
	pthread_attr_setschedparam (&attr, &sched_param);
	printk("About to thread create\n");
	thread_status0 = pthread_create (&T[0],  &attr, thread_code, (void *)0);
	thread_status1 = pthread_create (&T[1],  &attr, thread_code, (void *)1);
	if (thread_status0 != 0) {
		printk("failed to create RT-thread0\n");
		return -1;
	} else if (thread_status1 != 0) {
		printk("failed to create RT-thread1\n");
		return -1;
	} else {
		printk("created RT-threads\n");
	}

	return 0;
}


void cleanup_module(void)
{
        printk ("Removing module on CPU %d\n", rtl_getcpuid());
	pthread_delete_np (T[0]);
	pthread_delete_np (T[1]);
}

