/* genembbin.c
 * Generates a C-source include with data from binary files
 * This is a standalone code and not included in main Ziproxy executable.
 *
 * Ziproxy - the HTTP acceleration proxy
 * This code is under the following conditions:
 *
 * ---------------------------------------------------------------------
 * Copyright (c)2005-2010 Daniel Mealha Cabrita
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA
 * ---------------------------------------------------------------------
 */


#include <stdio.h>
#include <stdlib.h>

/* returns null if unsuccessful (or file is empty), otherwise:
 * pointed buffer must be freed after usage
 * returns data pointer into *filesize, if filesize != NULL
 * updates *file_size with the total bytes of it
/* FIXME: this routine does not expect IO errors */
char *load_binfile_to_memory (const char *given_filename, int *file_size)
{
	int my_filesize;
	char *my_buff;
	FILE *my_file;

	if ((my_file = fopen (given_filename, "rb")) != NULL) {
		/* determine file size */
		fseek (my_file, 0, SEEK_END);
		my_filesize = ftell (my_file);
		fseek (my_file, 0, SEEK_SET);
		//if (my_filesize = 0)
		//	return (NULL);

		if ((my_buff = malloc (my_filesize)) != NULL) {
			fread (my_buff, my_filesize, 1, my_file);
			fclose (my_file);
			*file_size = my_filesize;
			return (my_buff);
		} else {
			fclose (my_file);
		}
	}

	return (NULL);
}

void genembbin_fromfile (const char *table_name, const char *file_name)
{
	int file_size;
	char *file_buff;
	int i;

	if ((file_buff = load_binfile_to_memory (file_name, &file_size)) != NULL) {
		printf ("#define %s_size %d\n\n", table_name, file_size);
		printf ("const char %s [%d] = {\n", table_name, file_size);
		printf ("\t");
		for (i = 0; i < file_size; i++) {
			printf ("%d", file_buff [i]);
			if (i < (file_size - 1))
			printf (", ");
		}
		printf ("\n");
		printf ("};\n\n");
		free (file_buff);
	} else {
		fprintf (stderr, "ERROR: Unable to load input file: %s\n\n", file_name);
	}
}

main ()
{
	printf ("/* embbin.h\n"
		" * Embedded binaries' tables\n"
		" *\n"
		" * *** Do not edit this file directly, it was generated by genembbin.c\n"
		" * *** genembbin is not invoked neither compiled by make,\n"
		" * *** thus it should be compiled and executed manually.\n"
		" *\n"
		" * Ziproxy - the HTTP acceleration proxy\n"
		" * This code is under the following conditions:\n"
		" *\n"
		" * ---------------------------------------------------------------------\n"
		" * Copyright (c)2005-2010 Daniel Mealha Cabrita\n"
		" *\n"
		" * This program is free software; you can redistribute it and/or modify\n"
		" * it under the terms of the GNU General Public License as published by\n"
		" * the Free Software Foundation; either version 2 of the License, or\n"
		" * (at your option) any later version.\n"
		" *\n"
		" * This program is distributed in the hope that it will be useful,\n"
		" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
		" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n"
		" * GNU General Public License for more details.\n"
		" *\n"
		" * You should have received a copy of the GNU General Public License\n"
		" * along with this program; if not, write to the Free Software\n"
		" * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA\n"
		" * ---------------------------------------------------------------------\n"
		" */\n"
		"\n\n");
	printf ("//To stop multiple inclusions.\n"
		"#ifndef EMBBIN_H\n"
		"#define EMBBIN_H\n"
		"\n");

	genembbin_fromfile ("embbin_empty_image", "embbin/empty_image.gif");
	
	printf ("\n"
		"#endif\n"
		"\n");
}

