/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AdapterAlreadyActiveException;
import Ice.AdapterNotFoundException;
import Ice.Communicator;
import Ice.Connection;
import Ice.EndpointParseException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.InvalidReplicaGroupIdException;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.NotRegisteredException;
import Ice.Object;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterIdInUseException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import IceInternal.Endpoint;
import IceInternal.IncomingConnectionFactory;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.Reference;
import IceInternal.RouterInfo;
import IceInternal.ServantManager;
import IceUtil.Arrays;
import IceUtil.CloneException;
import IceUtil.StringUtil;
import java.util.Hashtable;
import java.util.Vector;

public final class ObjectAdapter {
    private boolean _deactivated = false;
    private Instance _instance;
    private Communicator _communicator;
    private ServantManager _servantManager;
    private boolean _printAdapterReadyDone;
    private String _name;
    private String _id;
    private String _replicaGroupId;
    private Vector _incomingConnectionFactories = new Vector();
    private Vector _routerEndpoints = new Vector();
    private Vector _routerInfos = new Vector();
    private Vector _publishedEndpoints;
    private LocatorInfo _locatorInfo;
    private int _directCount;
    private boolean _waitForDeactivate;

    public synchronized Communicator getCommunicator() {
        this.checkForDeactivation();
        return this._communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        java.lang.Object object;
        LocatorInfo locatorInfo = null;
        boolean bl = false;
        java.lang.Object object2 = this;
        synchronized (object2) {
            this.checkForDeactivation();
            if (!this._printAdapterReadyDone) {
                locatorInfo = this._locatorInfo;
                bl = this._instance.properties().getPropertyAsInt("Ice.PrintAdapterReady") > 0;
                this._printAdapterReadyDone = true;
            }
            int n = this._incomingConnectionFactories.size();
            object = this._incomingConnectionFactories.elements();
            while (object.hasMoreElements()) {
                IncomingConnectionFactory incomingConnectionFactory = (IncomingConnectionFactory)object.nextElement();
                incomingConnectionFactory.activate();
            }
        }
        if (this._id.length() > 0) {
            object2 = null;
            if (locatorInfo != null) {
                object2 = this._locatorInfo.getLocatorRegistry();
            }
            if (object2 != null) {
                try {
                    Identity identity = new Identity();
                    identity.category = "";
                    identity.name = "dummy";
                    if (this._replicaGroupId.length() == 0) {
                        object2.setAdapterDirectProxy(this._id, this.createDirectProxy(identity));
                    } else {
                        object2.setReplicatedAdapterDirectProxy(this._id, this._replicaGroupId, this.createDirectProxy(identity));
                    }
                }
                catch (ObjectAdapterDeactivatedException objectAdapterDeactivatedException) {
                }
                catch (AdapterNotFoundException adapterNotFoundException) {
                    object = new NotRegisteredException();
                    ((NotRegisteredException)object).kindOfObject = "object adapter";
                    ((NotRegisteredException)object).id = this._id;
                    throw object;
                }
                catch (InvalidReplicaGroupIdException invalidReplicaGroupIdException) {
                    object = new NotRegisteredException();
                    ((NotRegisteredException)object).kindOfObject = "replica group";
                    ((NotRegisteredException)object).id = this._replicaGroupId;
                    throw object;
                }
                catch (AdapterAlreadyActiveException adapterAlreadyActiveException) {
                    object = new ObjectAdapterIdInUseException();
                    ((ObjectAdapterIdInUseException)object).id = this._id;
                    throw object;
                }
            }
        }
        if (bl) {
            System.out.println(this._name + " ready");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        OutgoingConnectionFactory outgoingConnectionFactory;
        java.lang.Object object;
        Vector vector;
        java.lang.Object object2 = this;
        synchronized (object2) {
            if (this._deactivated) {
                return;
            }
            vector = new Vector(this._incomingConnectionFactories.size());
            object = this._incomingConnectionFactories.elements();
            while (object.hasMoreElements()) {
                vector.addElement(object.nextElement());
            }
            outgoingConnectionFactory = this._instance.outgoingConnectionFactory();
            this._deactivated = true;
            this.notifyAll();
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (IncomingConnectionFactory)object2.nextElement();
            ((IncomingConnectionFactory)object).destroy();
        }
        outgoingConnectionFactory.removeAdapter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDeactivate() {
        java.lang.Object object = this;
        synchronized (object) {
            while (!this._deactivated || this._directCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            while (this._waitForDeactivate) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this._waitForDeactivate = true;
        }
        if (this._incomingConnectionFactories != null) {
            object = this._incomingConnectionFactories.elements();
            while (object.hasMoreElements()) {
                IncomingConnectionFactory incomingConnectionFactory = (IncomingConnectionFactory)object.nextElement();
                incomingConnectionFactory.waitUntilFinished();
            }
        }
        if (this._servantManager != null) {
            this._servantManager.destroy();
        }
        object = this;
        synchronized (object) {
            this._waitForDeactivate = false;
            this.notifyAll();
            this._incomingConnectionFactories = null;
            this._instance = null;
            this._servantManager = null;
            this._communicator = null;
        }
    }

    public ObjectPrx add(Object object, Identity identity) {
        return this.addFacet(object, identity, "");
    }

    public synchronized ObjectPrx addFacet(Object object, Identity identity, String string) {
        this.checkForDeactivation();
        ObjectAdapter.checkIdentity(identity);
        Identity identity2 = new Identity();
        identity2.category = identity.category;
        identity2.name = identity.name;
        this._servantManager.addServant(object, identity2, string);
        return this.newProxy(identity2, string);
    }

    public synchronized ObjectPrx createDirectProxy(Identity identity) {
        this.checkForDeactivation();
        ObjectAdapter.checkIdentity(identity);
        return this.newDirectProxy(identity, "");
    }

    public synchronized void addRouter(RouterPrx routerPrx) {
        this.checkForDeactivation();
        RouterInfo routerInfo = this._instance.routerManager().get(routerPrx);
        if (routerInfo != null) {
            int n;
            this._routerInfos.addElement(routerInfo);
            ObjectPrxHelperBase objectPrxHelperBase = (ObjectPrxHelperBase)routerInfo.getServerProxy();
            Endpoint[] endpointArray = objectPrxHelperBase.__reference().getEndpoints();
            for (n = 0; n < endpointArray.length; ++n) {
                this._routerEndpoints.addElement(endpointArray[n]);
            }
            Arrays.sort(this._routerEndpoints);
            n = 0;
            while (n < this._routerEndpoints.size() - 1) {
                java.lang.Object e;
                java.lang.Object e2 = this._routerEndpoints.elementAt(n);
                if (e2.equals(e = this._routerEndpoints.elementAt(n + 1))) {
                    this._routerEndpoints.removeElementAt(n);
                    continue;
                }
                ++n;
            }
            routerInfo.setAdapter(this);
            this._instance.outgoingConnectionFactory().setRouterInfo(routerInfo);
        }
    }

    public synchronized void setLocator(LocatorPrx locatorPrx) {
        this.checkForDeactivation();
        this._locatorInfo = this._instance.locatorManager().get(locatorPrx);
    }

    public ServantManager getServantManager() {
        return this._servantManager;
    }

    public ObjectAdapter(Instance instance, Communicator communicator, String string, String string2) {
        this._instance = instance;
        this._communicator = communicator;
        this._servantManager = new ServantManager(instance, string);
        this._printAdapterReadyDone = false;
        this._name = string;
        this._id = instance.properties().getProperty(string + ".AdapterId");
        this._replicaGroupId = instance.properties().getProperty(string + ".ReplicaGroupId");
        this._directCount = 0;
        this._waitForDeactivate = false;
        try {
            String string3;
            java.lang.Object object;
            Vector vector = this.parseEndpoints(string2);
            for (int i = 0; i < vector.size(); ++i) {
                object = (Endpoint)vector.elementAt(i);
                this._incomingConnectionFactories.addElement(new IncomingConnectionFactory(instance, (Endpoint)object, this));
            }
            String string4 = this._instance.properties().getProperty(string + ".PublishedEndpoints");
            this._publishedEndpoints = this.parseEndpoints(string4);
            object = this._instance.properties().getProperty(string + ".Router");
            if (((String)object).length() > 0) {
                this.addRouter(RouterPrxHelper.uncheckedCast(this._instance.proxyFactory().stringToProxy((String)object)));
            }
            if ((string3 = this._instance.properties().getProperty(string + ".Locator")).length() > 0) {
                this.setLocator(LocatorPrxHelper.uncheckedCast(this._instance.proxyFactory().stringToProxy(string3)));
            } else {
                this.setLocator(this._instance.referenceFactory().getDefaultLocator());
            }
        }
        catch (LocalException localException) {
            this.deactivate();
            this.waitForDeactivate();
            throw localException;
        }
    }

    private ObjectPrx newProxy(Identity identity, String string) {
        if (this._id.length() == 0) {
            return this.newDirectProxy(identity, string);
        }
        if (this._replicaGroupId.length() == 0) {
            return this.newIndirectProxy(identity, string, this._id);
        }
        return this.newIndirectProxy(identity, string, this._replicaGroupId);
    }

    private ObjectPrx newDirectProxy(Identity identity, String string) {
        java.lang.Object object;
        int n;
        java.lang.Object[] objectArray;
        int n2 = this._publishedEndpoints.size();
        if (n2 > 0) {
            objectArray = new Endpoint[n2 + this._routerEndpoints.size()];
            this._publishedEndpoints.copyInto(objectArray);
        } else {
            n2 = this._incomingConnectionFactories.size();
            objectArray = new Endpoint[n2 + this._routerEndpoints.size()];
            for (n = 0; n < n2; ++n) {
                object = (IncomingConnectionFactory)this._incomingConnectionFactories.elementAt(n);
                objectArray[n] = ((IncomingConnectionFactory)object).endpoint();
            }
        }
        for (n = 0; n < this._routerEndpoints.size(); ++n) {
            objectArray[n2 + n] = (Endpoint)this._routerEndpoints.elementAt(n);
        }
        Connection[] connectionArray = new Connection[]{};
        object = this._instance.referenceFactory().create(identity, new Hashtable(), string, 0, false, (Endpoint[])objectArray, null);
        return this._instance.proxyFactory().referenceToProxy((Reference)object);
    }

    private ObjectPrx newIndirectProxy(Identity identity, String string, String string2) {
        Endpoint[] endpointArray = new Endpoint[]{};
        Connection[] connectionArray = new Connection[]{};
        Reference reference = this._instance.referenceFactory().create(identity, new Hashtable(), string, 0, false, string2, null, this._locatorInfo);
        return this._instance.proxyFactory().referenceToProxy(reference);
    }

    private void checkForDeactivation() {
        if (this._deactivated) {
            ObjectAdapterDeactivatedException objectAdapterDeactivatedException = new ObjectAdapterDeactivatedException();
            objectAdapterDeactivatedException.name = this._name;
            throw objectAdapterDeactivatedException;
        }
    }

    private static void checkIdentity(Identity identity) {
        if (identity.name == null || identity.name.length() == 0) {
            IllegalIdentityException illegalIdentityException = new IllegalIdentityException();
            try {
                illegalIdentityException.id = (Identity)identity.ice_clone();
            }
            catch (CloneException cloneException) {
                // empty catch block
            }
            throw illegalIdentityException;
        }
        if (identity.category == null) {
            identity.category = "";
        }
    }

    private Vector parseEndpoints(String string) {
        int n;
        string = string.toLowerCase();
        int n2 = 0;
        Vector<Endpoint> vector = new Vector<Endpoint>();
        while (n2 < string.length() && (n = StringUtil.findFirstNotOf(string, " \t\n\r", n2)) != -1) {
            n2 = string.indexOf(58, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            if (n2 == n) {
                ++n2;
                continue;
            }
            String string2 = string.substring(n, n2);
            Endpoint endpoint = this._instance.endpointFactory().create(string2);
            if (endpoint == null) {
                EndpointParseException endpointParseException = new EndpointParseException();
                endpointParseException.str = string2;
                throw endpointParseException;
            }
            vector.addElement(endpoint);
            ++n2;
        }
        return vector;
    }
}

