/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.AdapterNotFoundException;
import Ice.BooleanHolder;
import Ice.Identity;
import Ice.LocalException;
import Ice.LocatorPrx;
import Ice.LocatorRegistryPrx;
import Ice.LocatorRegistryPrxHelper;
import Ice.NotRegisteredException;
import Ice.ObjectNotFoundException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.Util;
import IceInternal.DirectReference;
import IceInternal.Endpoint;
import IceInternal.IndirectReference;
import IceInternal.LocatorTable;
import IceInternal.Reference;

public final class LocatorInfo {
    private LocatorPrx _locator;
    private LocatorRegistryPrx _locatorRegistry;
    private LocatorTable _table;

    LocatorInfo(LocatorPrx locatorPrx, LocatorTable locatorTable) {
        this._locator = locatorPrx;
        this._table = locatorTable;
    }

    public synchronized void destroy() {
        this._locatorRegistry = null;
        this._table.clear();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        LocatorInfo locatorInfo = null;
        try {
            locatorInfo = (LocatorInfo)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this._locator.equals(locatorInfo._locator);
    }

    public LocatorPrx getLocator() {
        return this._locator;
    }

    public synchronized LocatorRegistryPrx getLocatorRegistry() {
        if (this._locatorRegistry == null) {
            this._locatorRegistry = this._locator.getRegistry();
            this._locatorRegistry = LocatorRegistryPrxHelper.uncheckedCast(this._locatorRegistry.ice_locator(null));
        }
        return this._locatorRegistry;
    }

    public Endpoint[] getEndpoints(IndirectReference indirectReference, BooleanHolder booleanHolder) {
        Endpoint[] endpointArray = null;
        ObjectPrx objectPrx = null;
        booleanHolder.value = true;
        String string = indirectReference.getAdapterId();
        Identity identity = indirectReference.getIdentity();
        try {
            if (string.length() > 0) {
                endpointArray = this._table.getAdapterEndpoints(string);
                if (endpointArray == null) {
                    booleanHolder.value = false;
                    objectPrx = this._locator.findAdapterById(string);
                    if (objectPrx != null && (endpointArray = ((ObjectPrxHelperBase)objectPrx).__reference().getEndpoints()).length > 0) {
                        this._table.addAdapterEndpoints(string, endpointArray);
                    }
                }
            } else {
                boolean bl = true;
                objectPrx = this._table.getProxy(identity);
                if (objectPrx == null) {
                    bl = false;
                    objectPrx = this._locator.findObjectById(identity);
                }
                boolean bl2 = true;
                if (objectPrx != null) {
                    Reference reference = ((ObjectPrxHelperBase)objectPrx).__reference();
                    if (reference instanceof DirectReference) {
                        bl2 = false;
                        DirectReference directReference = (DirectReference)reference;
                        endpointArray = directReference.getEndpoints();
                    } else {
                        IndirectReference indirectReference2 = (IndirectReference)reference;
                        if (indirectReference2.getAdapterId().length() > 0) {
                            BooleanHolder booleanHolder2 = new BooleanHolder();
                            endpointArray = this.getEndpoints(indirectReference2, booleanHolder2);
                            bl2 = booleanHolder2.value;
                        }
                    }
                }
                if (!bl && endpointArray != null && endpointArray.length > 0) {
                    this._table.addProxy(identity, objectPrx);
                }
                booleanHolder.value = bl || bl2;
            }
        }
        catch (AdapterNotFoundException adapterNotFoundException) {
            NotRegisteredException notRegisteredException = new NotRegisteredException();
            notRegisteredException.kindOfObject = "object adapter";
            notRegisteredException.id = string;
            throw notRegisteredException;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            NotRegisteredException notRegisteredException = new NotRegisteredException();
            notRegisteredException.kindOfObject = "object";
            notRegisteredException.id = Util.identityToString(identity);
            throw notRegisteredException;
        }
        catch (NotRegisteredException notRegisteredException) {
            throw notRegisteredException;
        }
        catch (LocalException localException) {
            if (indirectReference.getInstance().traceLevels().location >= 1) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("couldn't contact the locator to retrieve adapter endpoints\n");
                if (string.length() > 0) {
                    stringBuffer.append("adapter = " + string + "\n");
                } else {
                    stringBuffer.append("object = " + Util.identityToString(identity) + "\n");
                }
                stringBuffer.append("reason = " + localException);
                indirectReference.getInstance().logger().trace(indirectReference.getInstance().traceLevels().locationCat, stringBuffer.toString());
            }
            throw localException;
        }
        if (indirectReference.getInstance().traceLevels().location >= 1 && endpointArray != null && endpointArray.length > 0) {
            if (booleanHolder.value) {
                this.trace("found endpoints in locator table", indirectReference, endpointArray);
            } else {
                this.trace("retrieved endpoints from locator, adding to locator table", indirectReference, endpointArray);
            }
        }
        return endpointArray == null ? new Endpoint[]{} : endpointArray;
    }

    public void clearObjectCache(IndirectReference indirectReference) {
        ObjectPrx objectPrx;
        if (indirectReference.getAdapterId().length() == 0 && (objectPrx = this._table.removeProxy(indirectReference.getIdentity())) != null) {
            if (((ObjectPrxHelperBase)objectPrx).__reference() instanceof IndirectReference) {
                IndirectReference indirectReference2 = (IndirectReference)((ObjectPrxHelperBase)objectPrx).__reference();
                if (indirectReference2.getAdapterId().length() > 0) {
                    this.clearCache(indirectReference2);
                }
            } else if (indirectReference.getInstance().traceLevels().location >= 2) {
                this.trace("removed endpoints from locator table", indirectReference, ((ObjectPrxHelperBase)objectPrx).__reference().getEndpoints());
            }
        }
    }

    public void clearCache(IndirectReference indirectReference) {
        if (indirectReference.getAdapterId().length() > 0) {
            Endpoint[] endpointArray = this._table.removeAdapterEndpoints(indirectReference.getAdapterId());
            if (endpointArray != null && indirectReference.getInstance().traceLevels().location >= 2) {
                this.trace("removed endpoints from locator table\n", indirectReference, endpointArray);
            }
        } else {
            ObjectPrx objectPrx = this._table.removeProxy(indirectReference.getIdentity());
            if (objectPrx != null) {
                if (((ObjectPrxHelperBase)objectPrx).__reference() instanceof IndirectReference) {
                    IndirectReference indirectReference2 = (IndirectReference)((ObjectPrxHelperBase)objectPrx).__reference();
                    if (indirectReference2.getAdapterId().length() > 0) {
                        this.clearCache(indirectReference2);
                    }
                } else if (indirectReference.getInstance().traceLevels().location >= 2) {
                    this.trace("removed endpoints from locator table", indirectReference, ((ObjectPrxHelperBase)objectPrx).__reference().getEndpoints());
                }
            }
        }
    }

    private void trace(String string, IndirectReference indirectReference, Endpoint[] endpointArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "\n");
        if (indirectReference.getAdapterId().length() > 0) {
            stringBuffer.append("adapter = " + indirectReference.getAdapterId() + "\n");
        } else {
            stringBuffer.append("object = " + Util.identityToString(indirectReference.getIdentity()) + "\n");
        }
        stringBuffer.append("endpoints = ");
        int n = endpointArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(((Object)endpointArray[i]).toString());
            if (i + 1 >= n) continue;
            stringBuffer.append(":");
        }
        indirectReference.getInstance().logger().trace(indirectReference.getInstance().traceLevels().locationCat, stringBuffer.toString());
    }
}

