/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.CommunicatorDestroyedException;
import Ice.Connection;
import Ice.LocalException;
import Ice.ObjectAdapter;
import IceInternal.Connector;
import IceInternal.DefaultsAndOverrides;
import IceInternal.Endpoint;
import IceInternal.Instance;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class OutgoingConnectionFactory {
    private Instance _instance;
    private boolean _destroyed;
    private Hashtable _connections = new Hashtable();
    private Hashtable _pending = new Hashtable();

    public synchronized void destroy() {
        if (this._destroyed) {
            return;
        }
        Enumeration enumeration = this._connections.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Connection connection = (Connection)enumeration2.nextElement();
                connection.destroy(1);
            }
        }
        this._destroyed = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        Hashtable hashtable;
        Object object = this;
        synchronized (object) {
            while (!this._destroyed || !this._pending.isEmpty()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            hashtable = this._connections;
            this._connections = null;
        }
        object = hashtable.elements();
        while (object.hasMoreElements()) {
            Vector vector = (Vector)object.nextElement();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                connection.waitUntilFinished();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection create(Endpoint[] endpointArray) {
        int n;
        Object object;
        Object object2;
        Endpoint[] endpointArray2 = new Endpoint[endpointArray.length];
        System.arraycopy(endpointArray, 0, endpointArray2, 0, endpointArray.length);
        DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
        Object object3 = this;
        synchronized (object3) {
            Vector vector;
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            object2 = this._connections.keys();
            while (object2.hasMoreElements()) {
                Object k = object2.nextElement();
                vector = (Vector)this._connections.get(k);
                for (int i = vector.size(); i > 0; --i) {
                    object = (Connection)vector.elementAt(i - 1);
                    if (!((Connection)object).isFinished()) continue;
                    vector.removeElementAt(i - 1);
                }
                if (!vector.isEmpty()) continue;
                this._connections.remove(k);
            }
            for (n = 0; n < endpointArray2.length; ++n) {
                if (!defaultsAndOverrides.overrideTimeout) continue;
                endpointArray2[n] = endpointArray2[n].timeout(defaultsAndOverrides.overrideTimeoutValue);
            }
            for (n = 0; n < endpointArray2.length; ++n) {
                vector = (Vector)this._connections.get(endpointArray2[n]);
                if (vector == null) continue;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (Connection)enumeration.nextElement();
                    if (((Connection)object).isDestroyed()) continue;
                    return object;
                }
            }
            n = 0;
            while (!this._destroyed) {
                int n2;
                for (n2 = 0; n2 < endpointArray2.length && !this._pending.contains(endpointArray2[n2]); ++n2) {
                }
                if (n2 == endpointArray2.length) break;
                n = 1;
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this._destroyed) {
                throw new CommunicatorDestroyedException();
            }
            if (n != 0) {
                for (int i = 0; i < endpointArray2.length; ++i) {
                    Vector vector2 = (Vector)this._connections.get(endpointArray2[i]);
                    if (vector2 == null) continue;
                    object = vector2.elements();
                    while (object.hasMoreElements()) {
                        Connection connection = (Connection)object.nextElement();
                        if (connection.isDestroyed()) continue;
                        return connection;
                    }
                }
            }
            for (int i = 0; i < endpointArray2.length; ++i) {
                this._pending.put(endpointArray2[i], endpointArray2[i]);
            }
        }
        object3 = null;
        object2 = null;
        for (n = 0; n < endpointArray2.length; ++n) {
            Endpoint endpoint = endpointArray2[n];
            try {
                Transceiver transceiver = endpoint.clientTransceiver();
                if (transceiver == null) {
                    object = endpoint.connector();
                    int n3 = defaultsAndOverrides.overrideConnectTimeout ? defaultsAndOverrides.overrideConnectTimeoutValue : endpoint.timeout();
                    transceiver = ((Connector)object).connect(n3);
                }
                object3 = new Connection(this._instance, transceiver, endpoint, null);
                ((Connection)object3).waitForValidation();
                break;
            }
            catch (LocalException localException) {
                object2 = localException;
                if (object3 != null) {
                    ((Connection)object3).waitUntilFinished();
                    object3 = null;
                }
                TraceLevels traceLevels = this._instance.traceLevels();
                if (traceLevels.retry < 2) continue;
                object = new StringBuffer();
                ((StringBuffer)object).append("connection to endpoint failed");
                if (n < endpointArray2.length - 1) {
                    ((StringBuffer)object).append(", trying next endpoint\n");
                } else {
                    ((StringBuffer)object).append(" and no more endpoints to try\n");
                }
                ((StringBuffer)object).append(((LocalException)object2).toString());
                this._instance.logger().trace(traceLevels.retryCat, ((StringBuffer)object).toString());
                continue;
            }
        }
        OutgoingConnectionFactory outgoingConnectionFactory = this;
        synchronized (outgoingConnectionFactory) {
            for (int i = 0; i < endpointArray2.length; ++i) {
                this._pending.remove(endpointArray2[i]);
            }
            this.notifyAll();
            if (object3 == null) {
                throw object2;
            }
            Vector<Object> vector = (Vector<Object>)this._connections.get(((Connection)object3).endpoint());
            if (vector == null) {
                vector = new Vector<Object>();
                this._connections.put(((Connection)object3).endpoint(), vector);
            }
            vector.addElement(object3);
            if (this._destroyed) {
                ((Connection)object3).destroy(1);
                throw new CommunicatorDestroyedException();
            }
        }
        return object3;
    }

    public synchronized void removeAdapter(ObjectAdapter objectAdapter) {
        if (this._destroyed) {
            throw new CommunicatorDestroyedException();
        }
        Enumeration enumeration = this._connections.elements();
        while (enumeration.hasMoreElements()) {
            Vector vector = (Vector)enumeration.nextElement();
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Connection connection = (Connection)enumeration2.nextElement();
                if (connection.getAdapter() != objectAdapter) continue;
                try {
                    connection.setAdapter(null);
                }
                catch (LocalException localException) {}
            }
        }
    }

    OutgoingConnectionFactory(Instance instance) {
        this._instance = instance;
        this._destroyed = false;
    }
}

