/*
 *	VME Linux/m68k Loader
 *
 *	(c) Copyright 1997 by Nick Holgate
 *
 *	This file is subject to the terms and conditions of the GNU General Public
 *	License.  See the file COPYING for more details.
 *
 *  MVME147/16x Configuration.
 */

/*--------------------------------------------------------------------------*/

/*
 * BOOTINFO_COMPAT_1_0:
 *	Include support for booting kernel with bootinfo version 1.0 (up to 2.0.x)
 */

#define		BOOTINFO_COMPAT_1_0		1

/*
 * MEMORY_BASE_ADDR:
 *  Base address of system memory.
 */
#define		MEMORY_BASE_ADDR		0x00000000

/*
 * MEMORY_SIZE:
 *  Size in bytes of system memory or zero to detect at run-time.
 */
#define		MEMORY_SIZE				0

/*
 * MEMORY_SCAN_INCREMENT:
 *  Size increment in bytes for memory scan (not used if MEMORY_SIZE != 0)
 */
#define	MEMORY_SCAN_INCREMENT		(256 * 1024)

/*
 * SYMBOL_SUPPORT:
 *  Include support for loading kernel symbols into debug monitor.
 */
#define		SYMBOL_SUPPORT			0

/*-----------------------------< end of file >------------------------------*/
