##--------------------------------------------------------------------------##
#
# Rules to make architecture independent parts of the kernel loader.
#
# (c) Copyright 1997 by Nick Holgate
#
# This file is subject to the terms and conditions of the GNU General Public
# License.  See the file COPYING for more details.
#

LDRCMN				=	$(TOPDIR)/loader/common
LDRINC				=	$(TOPDIR)/loader/include
UTILS				=	$(TOPDIR)/utils

##--------------------------------------------------------------------------##

ifneq ($(shell uname -m),m68k)
 CROSS_COMPILE		=	m68k-linux-
else
 CROSS_COMPILE		=	
endif

AR					=	ar
AS					=	$(CROSS_COMPILE)as
LD					=	$(CROSS_COMPILE)ld
CC					=	$(CROSS_COMPILE)gcc
STRIP				=	$(CROSS_COMPILE)strip
BIN2DATA			=	$(UTILS)/bin2data.pl

LOADER_COMMON_INCS	=	$(LDRINC)/loader.h		\
						$(LDRINC)/bootinfo.h	\
						$(LDRINC)/stream.h		\
						$(LDRINC)/loaderdefs.h	\
						config.h

LOADER_COMMON_OBJS	=	head.o loader.o gunzip_mod.o file_mod.o \
						stream.o misc.o

##--------------------------------------------------------------------------##

head.o:			$(LDRCMN)/head.c       $(LOADER_COMMON_INCS)
loader.o:		$(LDRCMN)/loader.c     $(LOADER_COMMON_INCS)
misc.o:			$(LDRCMN)/misc.c       $(LOADER_COMMON_INCS)
stream.o:		$(LDRCMN)/stream.c     $(LOADER_COMMON_INCS)
file_mod.o:		$(LDRCMN)/file_mod.c   $(LOADER_COMMON_INCS)
gunzip_mod.o:	$(LDRCMN)/gunzip_mod.c $(LOADER_COMMON_INCS) \
				$(LDRCMN)/inflate.c

##--------------------------------------------------------------------------##
# General rules
#

%.o:			%.S
				$(CC) -D__ASSEMBLY__ $(AFLAGS) -c $< -o $*.o

%.o:			%.c
				$(CC) $(CFLAGS) -c $< -o $*.o

%.o:			$(LDRCMN)/%.c
				$(CC) $(CFLAGS) -c $< -o $*.o

.PHONY:			all clean

##-----------------------------< end of file >------------------------------##
