/*
 * menu.h: A plugin for the Video Disk Recorder
 *
 * See the README file for copyright information and how to reach the author.
 *
 * $Id: menu.h,v 1.1 2004/10/24 12:57:09 chelli-guest Exp $
 */


#ifndef __CON_MENU_H_
#define __CON_MENU_H_



#include <vdr/menu.h>
#include <vdr/menuitems.h>

#include "config.h"
#include "engine.h"


#ifndef assert
#define assert(a...)
#endif





// --- cFontConsole ----------------------------------------------------------

class cFontConsole {
public:

  enum { NUMCHARS = 256 };
  typedef unsigned long tPixelData;
  struct tCharData {
    tPixelData width, height;
    tPixelData lines[ 1 ];
  };

private:
  const tCharData *data[ NUMCHARS ];

public:
  cFontConsole();

template <class T>
cFontConsole::cFontConsole( T& CharData ) {

  for ( int i = 0; i < NUMCHARS; i++ ) {

     data[ i ] = (tCharData *)&CharData[ i < 32 ? 0 : i - 32 ];
  }
}

  int Width( unsigned char c ) { return data[ c ]->width; }
  int Height( unsigned char c ) { return data[ c ]->height; }

  const tCharData *CharData( unsigned char c ) { return data[ c ]; }
};





// --- cMenuEditComboItem ----------------------------------------------------

struct sMenuEditComboItemData {
  int Key;
  const char* Value;
};



class cMenuEditComboItem : public cMenuEditIntItem {
protected:
  sMenuEditComboItemData *_data;
  int _dataCount;
  int _index;
  int* _pValue;
  virtual void Set(void);

public:
  cMenuEditComboItem(const char *Name, int *pValue, sMenuEditComboItemData *data, int dataCount);
  ~cMenuEditComboItem();
};





// --- cMenuSetup ---------------------------------------------------------------

class cMenuConsoleSetup : public cMenuSetupPage {
private:
  sConsoleConfig data;

protected:
  void AddNewCategory( const char* title );
  virtual void Store(void);

public:
  cMenuConsoleSetup();
};





// --- cMenuConsoleItem ---------------------------------------------------------

#define INPUT_BUFSIZE 1024

class cMenuConsoleItem : public cOsdItem {
private:
  int _x, _y, _w, _h;
  int _pixelW, _pixelH, _charsW, _charsH, _charW, _charH;

  cFontConsole _font;
  cBitmap *_pBitmap, *_pBitmapBottom;

  cVirtualConsole* _pConsole;
  bool _inputActivated;

  bool _blink, _blinkOld;
  int _inputState;
  bool _needClear;
  int _toRing;

private:
  void CaptureKeyboard();
  void ReleaseKeyboard();
  void WriteToConsole( const uint64& code );

public:
  cMenuConsoleItem(int consoleNr, int X, int Y, int W, int H);
  ~cMenuConsoleItem();
  void Clear(void);
  virtual void Display(int Offset = -1, eDvbColor FgColor = clrWhite, eDvbColor BgColor = clrBackground);
  virtual eOSState ProcessKey(eKeys Key);

  const char* getTitle() { return _pConsole->getTitle(); }
  bool getCaptured() { return _inputActivated; }
  bool getToRing() { return _toRing; }
};





// --- cMenuConsole -------------------------------------------------------------

class cMenuConsole : public cOsdMenu {
private:
  int _consoleNr;

private:
  void RefreshTitle();

public:
  cMenuConsole( int consoleNr );
  virtual eOSState ProcessKey( eKeys Key );
  void Display();
};





// --- cMenuConsoleList ---------------------------------------------------------

class cMenuConsoleList : public cOsdMenu {
private:
  void UpdateHelp();
  virtual void Set(void);
  bool TerminateConsole();

public:
  cMenuConsoleList();
  ~cMenuConsoleList();
  virtual eOSState ProcessKey(eKeys Key);
  };






// --- cMenuCommands ---------------------------------------------------------

class cMenuConsoleCommands : public cOsdMenu {
private:
  int nrConsole;
private:
  eOSState Execute(void);
public:
  cMenuConsoleCommands(void);
  virtual eOSState ProcessKey(eKeys Key);
};



#endif // __CON_MENU_H_

