#include "cs.h"
/* xi [top...n-1] = nodes reachable from graph of L*P' via nodes in B(:,k).
 * xi [n...2n-1] used as workspace */
int cs_reach (cs *L, const cs *B, int k, int *xi, const int *Pinv)
{
    int p, n, top, *Bp, *Bi, *Lp ;
    if (!L || !B || !xi) return (-1) ;
    n = L->n ; Bp = B->p ; Bi = B->i ; Lp = L->p ;
    top = n ;
    for (p = Bp [k] ; p < Bp [k+1] ; p++)
    {
	if (!CS_MARKED (Lp, Bi [p]))	/* start a dfs at unmarked node i */
	{
	    top = cs_dfs (Bi [p], L, top, xi, xi+n, Pinv) ;
	}
    }
    for (p = top ; p < n ; p++) CS_MARK (Lp, xi [p]) ;	/* restore L */
    return (top) ;
}
