#include "cs_mex.h"
/* cs_amd: approximate minimum degree ordering */
void mexFunction
(
    int nargout,
    mxArray *pargout [ ],
    int nargin,
    const mxArray *pargin [ ]
)
{
    cs Amatrix, *A ;
    int *P, order ;
    if (nargout > 1 || nargin > 2)
    {
	mexErrMsgTxt ("Usage: p = cs_amd(A,order)") ;
    }
    A = cs_get_sparse (&Amatrix, 0, 0, pargin [0]) ;	    /* get A */
    order = (nargin > 1) ? mxGetScalar (pargin [1]) : 0 ;   /* get ordering */
    P = cs_amd (A, order) ;			    /* min. degree ordering */
    pargout [0] = cs_put_int (P, A->n, 1, 1) ;	    /* return P */
}
