function [p cparent cmember] = nesdis (A, mode, nsmall)
%NESDIS:  nested dissection ordering via CHOLMOD's nested dissection.
%   p = nesdis(A)         returns p such chol(A(p,p)) is typically sparser than
%                         chol(A).  Uses tril(A) and assumes A is symmetric.
%   p = nesdis(A,'sym')   the same as p=nesdis(A).
%   p = nesdis(A,'col')   returns p so that chol(A(:,p)'*A(:,p)) is typically
%                         sparser than chol(A'*A).
%   p = nesdis(A,'row')   returns p so that chol(A(p,:)*A(p,:)') is typically
%                         sparser than chol(A'*A).
%
%   A must be square for p=nesdis(A) or nesdis(A,'sym').
%
%   With three output arguments, [p cp cmember] = nesdis(...), the separator
%   tree and node-to-component mapping is returned.  cmember(i)=c means that
%   node i is in component c, where c is in the range of 1 to the number of
%   components.  length(cp) is the number of components found.  cp is the
%   separator tree; cp(c) is the parent of component c, or 0 if c is a root.
%   There can be anywhere from 1 to n components, where n is dimension of A,
%   A*A', or A'*A.  cmember is a vector of length n.
%
%   An optional 3rd input argument, nesdis (A,mode,nsmall), specifies the
%   smallest subgraph that should not be partitioned (default is 200).
%
%   NESDIS uses METIS' node separator algorithm to recursively partition the
%   graph.  This gives a set of constraints (cmember) that is then passed to
%   CCOLAMD, a constrained minimum degree ordering algorithm.  NESDIS typically
%   takes more time than METIS, but tends to produce better orderings.
%
%   Requires METIS, authored by George Karypis, Univ. of Minnesota.  This
%   MATLAB interface, via CHOLMOD, is by Tim Davis.
%
%   See also METIS, BISECT, CCOLAMD, CSYMAMD

error ('nesdis mexFunction not found') ;
