/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import org.javagroups.JChannel;
import org.javagroups.JChannelFactory;
import org.javagroups.blocks.DistributedHashtable;
import org.javagroups.blocks.ReplicatedHashtable;
import org.javagroups.debug.Debugger;
import org.javagroups.log.Trace;

public class HashtableTest {
    static int NUM_ITEMS = 1000;
    static long start;
    static long stop;

    public static void main(String[] args) {
        boolean use_replicated_hashtable = false;
        boolean debug = false;
        boolean cummulative = false;
        Debugger debugger = null;
        String props = "UDP(mcast_addr=224.0.0.36;mcast_port=55566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=5000):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=16000;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-help")) {
                HashtableTest.help();
                return;
            }
            if (args[i].equals("-use_rht")) {
                use_replicated_hashtable = true;
            } else if (args[i].equals("-props")) {
                props = args[++i];
            } else if (args[i].equals("-debug")) {
                debug = true;
            } else if (args[i].equals("-cummulative")) {
                cummulative = true;
            }
            ++i;
        }
        Trace.init();
        try {
            Hashtable ht;
            if (use_replicated_hashtable) {
                ht = new ReplicatedHashtable("HashtableTest", new JChannelFactory(), props, 1000L);
                if (debug) {
                    debugger = new Debugger((JChannel)((ReplicatedHashtable)ht).getChannel(), cummulative);
                }
                ((ReplicatedHashtable)ht).addNotifier(new Notifier(NUM_ITEMS));
            } else {
                ht = new DistributedHashtable("HashtableTest", new JChannelFactory(), props, 1000L);
                if (debug) {
                    debugger = new Debugger((JChannel)((DistributedHashtable)ht).getChannel(), cummulative);
                }
            }
            if (debugger != null) {
                debugger.start();
            }
            System.out.println("Hashtable already has " + ht.size() + " items");
            System.out.print("Press key to insert " + NUM_ITEMS + " 1k items into DistributedHashtable");
            System.in.read();
            byte[] buf = new byte[1024];
            i = 0;
            while (i < buf.length) {
                buf[i] = 120;
                ++i;
            }
            start = System.currentTimeMillis();
            i = 1;
            while (i <= NUM_ITEMS) {
                ht.put(new Integer(i), buf);
                if (i % 100 == 0) {
                    System.out.println(i);
                }
                ++i;
            }
            stop = System.currentTimeMillis();
            System.out.println(i + " elements took " + (stop - start) + " msecs to " + (use_replicated_hashtable ? "send" : "insert"));
            while (true) {
                System.out.println("Hashtable has " + ht.size() + " entries");
                System.in.read();
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
            return;
        }
    }

    static void help() {
        System.out.println("HashtableTest [-help] [-use_rht] [-props <properties>] [-debug] [-cummulative]");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class Notifier
    implements DistributedHashtable.Notification,
    ReplicatedHashtable.Notification {
        int num_items;
        int tmp;

        public void entrySet(Object key, Object value) {
            this.tmp = (Integer)key;
            if (this.tmp % 100 == 0) {
                System.out.println("** entrySet(" + key + ')');
            }
            if (this.tmp >= this.num_items) {
                stop = System.currentTimeMillis();
                System.out.println(this.num_items + " elements took " + (stop - start) + " msecs to receive and insert");
            }
        }

        public void entryRemoved(Object key) {
        }

        public void viewChange(Vector new_mbrs, Vector old_mbrs) {
            System.out.println("** viewChange(" + new_mbrs + ", " + old_mbrs + ')');
        }

        public void contentsSet(Map m) {
            System.out.println("** contentsSet (" + (m != null ? "" + m.size() : "0") + " items");
        }

        public void contentsCleared() {
            System.out.println("** contentsCleared()");
        }

        private final /* synthetic */ void this() {
            this.num_items = 0;
        }

        Notifier(int n) {
            this.this();
            this.num_items = n;
        }
    }
}

