/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.tests;

import org.javagroups.ChannelException;
import org.javagroups.blocks.DistributedHashtable;
import org.javagroups.log.Trace;
import org.javagroups.util.Util;

public class DistributedHashDeadLock {
    public static void main(String[] arg) throws ChannelException {
        System.out.println("Starting hashtable");
        String props = "UDP(mcast_addr=224.0.0.35;mcast_port=45566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2:FD:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(max_xmit_size=16000;gc_lag=1500;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=2000):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=16000;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
        Trace.init();
        DistributedHashtable distHash = new DistributedHashtable("ADMINT", null, props, 20000L);
        boolean odd = false;
        int numberofelements = 1000;
        Util.sleep(5000L);
        System.out.println("size: " + distHash.size());
        if (distHash.size() > 0) {
            odd = true;
        }
        boolean fillup = false;
        if (!odd) {
            System.out.println("Loading hashtable with " + numberofelements + " elements. Don't start the other instance");
        }
        int i = 0;
        while (!odd && i < numberofelements) {
            if (i % 50 == 0) {
                System.out.print("" + i + ' ');
            }
            distHash.put("number" + i, new Integer(0));
            fillup = true;
            ++i;
        }
        if (fillup) {
            System.out.println("\n\nHashtable filled, you can now start the other instance\n");
        }
        System.out.println("initilising with odd: " + odd + " and size " + distHash.size());
        while (true) {
            try {
                System.out.println("#######################################################");
                Thread.sleep(10000L);
                int count = 0;
                int i2 = 0;
                while (i2 < numberofelements) {
                    int value = (Integer)distHash.get("number" + i2);
                    System.out.print("" + value + ' ');
                    if (i2 % 50 == 0) {
                        System.out.print("\n");
                    }
                    if (odd && value % 2 != 0) {
                        ++count;
                        distHash.put("number" + i2, new Integer(++value));
                    } else if (!odd && value % 2 == 0) {
                        ++count;
                        distHash.put("number" + i2, new Integer(++value));
                    }
                    ++i2;
                }
                System.out.println("\n" + odd + " through all session, changed: " + count);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }
}

