/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.log;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.javagroups.log.Format;
import org.javagroups.log.NetworkTracer;
import org.javagroups.log.SystemErrTracer;
import org.javagroups.log.SystemOutTracer;
import org.javagroups.log.Tracer;
import org.javagroups.log.WriterTracer;

public class Trace {
    public static boolean trace = true;
    public static final boolean debug = false;
    public static final boolean copy = false;
    public static final int DEBUG = 0;
    public static final int TEST = 1;
    public static final int INFO = 2;
    public static final int WARN = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;
    protected static final String DEFAULT_OUTPUT_FILE_NAME = "default.out";
    protected static final String TRACE_STMT = "trace";
    protected static final String DEFAULT_OUTPUT_STMT = "default_output";
    protected static final String TIMESTAMP_FORMAT_STMT = "timestamp_format";
    protected static final String STDOUT_STMT = "STDOUT";
    protected static final String STDERR_STMT = "STDERR";
    protected static final String DEFAULT_OUTPUT = "default_output";
    protected static final HashMap TRACERS = new HashMap();
    protected static final Tracer[] STDOUTS = new Tracer[]{new SystemOutTracer(0), new SystemOutTracer(1), new SystemOutTracer(2), new SystemOutTracer(3), new SystemOutTracer(4), new SystemOutTracer(5)};
    protected static final Tracer[] STDERRS = new Tracer[]{new SystemErrTracer(0), new SystemErrTracer(1), new SystemErrTracer(2), new SystemErrTracer(3), new SystemErrTracer(4), new SystemErrTracer(5)};
    protected static Tracer defaultTracer = null;
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected static final String FILE_SEPARATOR = System.getProperty("file.separator");
    protected static String identifier = null;
    static /* synthetic */ Class class$org$javagroups$log$Trace;

    private static final void init(InputStream in) throws IOException, SecurityException {
        Properties p = new Properties();
        p.load(in);
        Iterator<Map.Entry<Object, Object>> it = p.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            Trace.parse((String)entry.getKey(), (String)entry.getValue());
        }
        Trace.setAutoFlushAll(true);
        Trace.setAutoFlushDefault(true);
    }

    public static void init(String fname) throws IOException, SecurityException {
        File f = new File(fname);
        if (f.isDirectory()) {
            fname = fname + FILE_SEPARATOR + "javagroups.properties";
        }
        FileInputStream in = new FileInputStream(fname);
        Trace.init(in);
    }

    public static void init() {
        String home_dir = System.getProperty("user.home");
        if (home_dir == null) {
            System.err.println("Trace.init(): user's home directory (\"user.home\") was not set");
        } else {
            home_dir = home_dir + FILE_SEPARATOR + "javagroups.properties";
            try {
                Trace.init(home_dir);
                return;
            }
            catch (Exception ex) {
                System.err.println("Trace.init() " + ex);
            }
        }
        try {
            InputStream in;
            Class clazz = class$org$javagroups$log$Trace;
            if (clazz == null) {
                clazz = class$org$javagroups$log$Trace = Trace.class$("[Lorg.javagroups.log.Trace;", false);
            }
            if ((in = clazz.getResourceAsStream("/javagroups.properties")) != null) {
                Trace.init(in);
                return;
            }
        }
        catch (Exception x) {
            x.printStackTrace();
            System.err.println("Trace.init() " + x);
        }
    }

    public static Tracer getStdoutTracer(int level) {
        return STDOUTS[level];
    }

    public static void flushStdouts() {
        int i = 0;
        while (i < STDOUTS.length) {
            STDOUTS[i].flush();
            ++i;
        }
    }

    public static void setAutoFlushForAllStdouts(boolean auto) {
        int i = 0;
        while (i < STDOUTS.length) {
            STDOUTS[i].setAutoFlush(auto);
            ++i;
        }
    }

    public static Tracer getStderrTracer(int level) {
        return STDERRS[level];
    }

    public static void flushStderrs() {
        int i = 0;
        while (i < STDERRS.length) {
            STDERRS[i].flush();
            ++i;
        }
    }

    public static void setAutoFlushForAllStderrs(boolean auto) {
        int i = 0;
        while (i < STDERRS.length) {
            STDERRS[i].setAutoFlush(auto);
            ++i;
        }
    }

    public static void setIdentifier(String id) {
        identifier = id;
    }

    public static void setTrace(boolean t) {
        trace = t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setOutput(String module, int level) {
        block5: {
            if (Trace.bogusModuleName(module)) {
                return;
            }
            Tracer tracer = null;
            HashMap hashMap = TRACERS;
            synchronized (hashMap) {
                tracer = Trace.lookup(module);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl8 : MonitorExitStatement: MONITOREXIT : var3_3
                if (tracer == null) break block5;
            }
            if (tracer != Trace.getDefaultTracer()) {
                tracer.setLevel(level);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setOutput(String module, int level, String fileName) throws IOException {
        if (Trace.bogusModuleName(module)) {
            return;
        }
        WriterTracer tracer = null;
        HashMap hashMap = TRACERS;
        synchronized (hashMap) {
            Trace.closeOutput(module);
            if (fileName == null) {
                return;
            }
            File f = new File(fileName);
            if (f.isDirectory()) {
                fileName = Trace.makeOutputFileName(module, level);
                f = new File(f, fileName);
            }
            FileWriter out = new FileWriter(f.getAbsolutePath(), true);
            tracer = new WriterTracer(module, level, out);
            Trace.addTracer(module, tracer);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setOutput(String module, int level, PrintStream outputStream) {
        if (Trace.bogusModuleName(module)) {
            return;
        }
        Tracer tracer = null;
        HashMap hashMap = TRACERS;
        synchronized (hashMap) {
            Trace.closeOutput(module);
            tracer = outputStream == null ? null : (outputStream.equals(System.err) ? Trace.getStderrTracer(level) : (outputStream.equals(System.out) ? Trace.getStdoutTracer(level) : new WriterTracer(module, level, new PrintWriter(outputStream))));
            Trace.addTracer(module, tracer);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setOutput(String module, int level, PrintWriter writer) {
        if (Trace.bogusModuleName(module)) {
            return;
        }
        WriterTracer tracer = null;
        HashMap hashMap = TRACERS;
        synchronized (hashMap) {
            Trace.closeOutput(module);
            WriterTracer writerTracer = writer == null ? null : new WriterTracer(module, level, writer);
            tracer = writerTracer;
            Trace.addTracer(module, tracer);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setOutput(String module, int level, String host, int port) throws UnknownHostException, IOException {
        if (Trace.bogusModuleName(module)) {
            return;
        }
        NetworkTracer tracer = null;
        HashMap hashMap = TRACERS;
        synchronized (hashMap) {
            Trace.closeOutput(module);
            NetworkTracer networkTracer = host == null ? null : new NetworkTracer(module, level, new Socket(host, port));
            tracer = networkTracer;
            Trace.addTracer(module, tracer);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setOutput(String module, int level, InetAddress addr, int port) throws IOException {
        if (Trace.bogusModuleName(module)) {
            return;
        }
        NetworkTracer tracer = null;
        HashMap hashMap = TRACERS;
        synchronized (hashMap) {
            Trace.closeOutput(module);
            NetworkTracer networkTracer = addr == null ? null : new NetworkTracer(module, level, new Socket(addr, port));
            tracer = networkTracer;
            Trace.addTracer(module, tracer);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeOutput(String module) {
        if (Trace.bogusModuleName(module)) {
            return;
        }
        HashMap hashMap = TRACERS;
        synchronized (hashMap) {
            Tracer tracer = Trace.lookup(module);
            if (tracer != null && tracer != Trace.getDefaultTracer()) {
                tracer.close();
            }
            Trace.removeTracer(module);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeAllOutputs() {
        HashMap hashMap = TRACERS;
        synchronized (hashMap) {
            Iterator iter = TRACERS.values().iterator();
            while (true) {
                if (!iter.hasNext()) {
                    TRACERS.clear();
                    return;
                }
                Tracer tracer = (Tracer)iter.next();
                tracer.close();
            }
        }
    }

    public static void flushOutput(String module) {
        if (Trace.bogusModuleName(module)) {
            return;
        }
        Tracer tracer = Trace.lookup(module);
        if (tracer != null) {
            tracer.flush();
        }
    }

    public static void flushAllOutputs() {
        Iterator iter = TRACERS.values().iterator();
        while (iter.hasNext()) {
            Tracer tracer = (Tracer)iter.next();
            tracer.flush();
        }
        Trace.flushStdouts();
        Trace.flushStderrs();
    }

    public static void setAutoFlush(String module, boolean auto) {
        if (Trace.bogusModuleName(module)) {
            return;
        }
        Tracer tracer = Trace.lookup(module);
        if (tracer != null) {
            tracer.setAutoFlush(auto);
        }
    }

    public static void setAutoFlushAll(boolean auto) {
        Iterator iter = TRACERS.values().iterator();
        while (iter.hasNext()) {
            Tracer tracer = (Tracer)iter.next();
            tracer.setAutoFlush(auto);
        }
        Trace.setAutoFlushForAllStdouts(auto);
        Trace.setAutoFlushForAllStderrs(auto);
    }

    public static void setAutoFlushDefault(boolean auto) {
        Tracer tracer = Trace.getDefaultTracer();
        if (tracer != null) {
            tracer.setAutoFlush(auto);
        }
    }

    public static void print(String module, int level, String message) {
        if (defaultTracer == null && TRACERS.size() == 0) {
            return;
        }
        Tracer tracer = Trace.findTracerFor(module);
        if (tracer != null) {
            tracer.print(module, level, message);
        }
    }

    public static void print(String module, int level, String identifier, String message) {
        if (defaultTracer == null && TRACERS.size() == 0) {
            return;
        }
        Tracer tracer = Trace.findTracerFor(module);
        if (tracer != null) {
            tracer.print(module, level, identifier, message);
        }
    }

    public static void println(String module, int level, String message) {
        if (identifier != null) {
            Trace.print(module, level, identifier, message + NEWLINE);
        } else {
            Trace.print(module, level, message + NEWLINE);
        }
    }

    public static void debug(String module, String message) {
        Trace.println(module, 0, message);
    }

    public static void test(String module, String message) {
        Trace.println(module, 1, message);
    }

    public static void info(String module, String message) {
        Trace.println(module, 2, message);
    }

    public static void warn(String module, String message) {
        Trace.println(module, 3, message);
    }

    public static void error(String module, String message) {
        Trace.println(module, 4, message);
    }

    public static void fatal(String module, String message) {
        Trace.println(module, 5, message);
    }

    public static void setTimestampFormat(String format) {
        Tracer.setTimestampFormat(format);
    }

    protected static Tracer getDefaultTracer() {
        return defaultTracer;
    }

    public static synchronized void restoreDefaultOutput() {
        if (defaultTracer != null) {
            defaultTracer.close();
        }
        defaultTracer = null;
    }

    public static synchronized void closeDefaultOutput() {
        if (defaultTracer != null) {
            defaultTracer.close();
        }
        defaultTracer = null;
    }

    public static synchronized void setDefaultOutput(int level, String fileName) throws IOException {
        Trace.closeDefaultOutput();
        if (fileName != null) {
            File f = new File(fileName);
            if (f.isDirectory()) {
                f = new File(f, DEFAULT_OUTPUT_FILE_NAME);
            }
            FileWriter out = new FileWriter(f.getAbsolutePath(), true);
            defaultTracer = new WriterTracer("", level, out);
        }
    }

    public static synchronized void setDefaultOutput(String fileName) throws IOException {
        Trace.setDefaultOutput(0, fileName);
    }

    public static synchronized void setDefaultOutput(int level, PrintStream outputStream) {
        Trace.closeDefaultOutput();
        defaultTracer = outputStream == null ? null : (outputStream.equals(System.err) ? Trace.getStderrTracer(level) : (outputStream.equals(System.out) ? Trace.getStdoutTracer(level) : new WriterTracer("", level, new PrintWriter(outputStream))));
        defaultTracer.setLevel(level);
    }

    public static synchronized void setDefaultOutput(PrintStream outputStream) {
        Trace.setDefaultOutput(0, outputStream);
    }

    public static synchronized void setDefaultOutput(int level, PrintWriter writer) {
        Trace.closeDefaultOutput();
        Tracer tracer = defaultTracer = writer == null ? null : new WriterTracer("", level, writer);
        if (defaultTracer != null) {
            defaultTracer.setLevel(level);
        }
    }

    public static synchronized void setDefaultOutput(PrintWriter writer) {
        Trace.setDefaultOutput(0, writer);
    }

    public static synchronized void setDefaultOutput(int level, String host, int port) throws UnknownHostException, IOException {
        Trace.closeDefaultOutput();
        Tracer tracer = defaultTracer = host == null ? null : new NetworkTracer("", level, new Socket(host, port));
        if (defaultTracer != null) {
            defaultTracer.setLevel(level);
        }
    }

    public static synchronized void setDefaultOutput(String host, int port) throws UnknownHostException, IOException {
        Trace.setDefaultOutput(0, host, port);
    }

    public static synchronized void setDefaultOutput(int level, InetAddress addr, int port) throws IOException {
        Trace.closeDefaultOutput();
        Tracer tracer = defaultTracer = addr == null ? null : new NetworkTracer("", level, new Socket(addr, port));
        if (defaultTracer != null) {
            defaultTracer.setLevel(level);
        }
    }

    public static synchronized void setDefaultOutput(InetAddress addr, int port) throws IOException {
        Trace.setDefaultOutput(0, addr, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void addTracer(String module, Tracer tracer) {
        HashMap hashMap = TRACERS;
        synchronized (hashMap) {
            TRACERS.put(Trace.moduleLookupName(module), tracer);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void removeTracer(String module) {
        HashMap hashMap = TRACERS;
        synchronized (hashMap) {
            TRACERS.remove(Trace.moduleLookupName(module));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Tracer lookup(String module) {
        HashMap hashMap = TRACERS;
        synchronized (hashMap) {
            return (Tracer)TRACERS.get(Trace.moduleLookupName(module));
        }
    }

    protected static String moduleLookupName(String module) {
        int parenPos = module.indexOf(40);
        return parenPos == -1 ? module : module.substring(0, parenPos + 1);
    }

    protected static Tracer findTracerFor(String module) {
        if (Trace.bogusModuleName(module)) {
            return Trace.getDefaultTracer();
        }
        Tracer tracer = null;
        int parenPos = module.indexOf(40);
        if (parenPos == -1) {
            tracer = (Tracer)TRACERS.get(module);
            return tracer == null ? Trace.getDefaultTracer() : tracer;
        }
        tracer = (Tracer)TRACERS.get(module = module.substring(0, parenPos));
        if (tracer == null) {
            int dotPos = module.lastIndexOf(46);
            while (dotPos != -1 && tracer == null) {
                module = module.substring(0, dotPos);
                tracer = (Tracer)TRACERS.get(module);
                dotPos = module.lastIndexOf(46);
            }
        }
        if (tracer == null) {
            tracer = Trace.getDefaultTracer();
        }
        return tracer;
    }

    protected static String makeOutputFileName(String module, int level) {
        int pos = (module = Trace.moduleLookupName(module)).indexOf(40);
        if (pos != -1) {
            module = module.substring(0, pos);
        }
        return module + '_' + Format.levelToString(level);
    }

    protected static boolean bogusModuleName(String module) {
        int dotPos;
        int parenPos = module.indexOf(40);
        return parenPos != -1 && (dotPos = module.indexOf(46)) == -1;
    }

    protected static void parse(String key, String val) {
        if (key == null || val == null) {
            System.err.println("Trace.Parse(): key or val is null");
            return;
        }
        if ((key = key.toLowerCase()).equals(TRACE_STMT)) {
            trace = new Boolean(val);
        } else if (key.startsWith(TRACE_STMT)) {
            Trace.parseTrace(val);
        } else if (key.startsWith("default_output")) {
            Trace.parseDefaultOutput(val);
        } else if (key.startsWith(TIMESTAMP_FORMAT_STMT)) {
            Trace.parseTimestampFormat(val);
        } else {
            System.err.println("Trace.Parse(): statement \"" + key + "\" not valid");
        }
    }

    protected static void parseTrace(String val) {
        StringTokenizer tok = new StringTokenizer(val);
        int lvl = -1;
        PrintStream outstream = null;
        String module = tok.nextToken();
        String level = tok.nextToken();
        String output = tok.nextToken();
        lvl = Trace.string2Level(level);
        if (lvl == -1) {
            return;
        }
        String tmp = output.toLowerCase();
        if (tmp.equals("stdout")) {
            outstream = System.out;
        } else if (tmp.equals("stderr")) {
            outstream = System.err;
        }
        if (outstream != null) {
            Trace.setOutput(module, lvl, outstream);
        } else {
            try {
                Trace.setOutput(module, lvl, output);
            }
            catch (Exception ex) {
                System.err.println("Trace.ParseTrace() " + ex);
            }
        }
    }

    protected static void parseDefaultOutput(String val) {
        StringTokenizer tok = new StringTokenizer(val);
        PrintStream outstream = null;
        int lvl = -1;
        String level = tok.nextToken();
        String output = tok.nextToken();
        lvl = Trace.string2Level(level);
        if (lvl == -1) {
            return;
        }
        String tmp = output.toLowerCase();
        if (tmp.equals("stdout")) {
            outstream = System.out;
        } else if (tmp.equals("stderr")) {
            outstream = System.err;
        }
        if (outstream != null) {
            Trace.setDefaultOutput(lvl, outstream);
        } else {
            try {
                Trace.setDefaultOutput(lvl, output);
            }
            catch (Exception ex) {
                System.err.println("Trace.ParseDefaultOutput() " + ex);
            }
        }
    }

    protected static void parseTimestampFormat(String val) {
        Trace.setTimestampFormat(val);
    }

    protected static int string2Level(String l) {
        if (l == null) {
            return -1;
        }
        String tmp = l.toLowerCase();
        if (tmp.equals("debug")) {
            return 0;
        }
        if (tmp.equals("test")) {
            return 1;
        }
        if (tmp.equals("info")) {
            return 2;
        }
        if (tmp.equals("warn")) {
            return 3;
        }
        if (tmp.equals("error")) {
            return 4;
        }
        if (tmp.equals("fatal")) {
            return 5;
        }
        System.err.println("Trace.String2Level(): level \"" + l + "\" is not known");
        return -1;
    }

    public static String getStackTrace(Throwable x) {
        if (x == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(bout);
        x.printStackTrace(writer);
        String result = new String(bout.toByteArray());
        return result;
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private Trace() {
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public final void run() {
                Trace.closeAllOutputs();
            }
        });
    }
}

