/**********************************************************************
 *
 *    FILE:            TexEnv.cpp
 *
 *    DESCRIPTION:    Read/Write osg::TexEnv in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerated
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 21.3.2003
 *
 *    Copyright 2003 VR-C
 **********************************************************************/

#include "Exception.h"
#include "TexEnv.h"
#include "Object.h"

using namespace ive;

void TexEnv::write(DataOutputStream* out){
    // Write TexEnv's identification.
    out->writeInt(IVETEXENV);
    // If the osg class is inherited by any other class we should also write this to file.
    osg::Object*  obj = dynamic_cast<osg::Object*>(this);
    if(obj){
        ((ive::Object*)(obj))->write(out);
    }
    else
        throw Exception("TexEnv::write(): Could not cast this osg::TexEnv to an osg::Object.");
    // Write TexEnv's properties.

    // Write mode
    out->writeInt(getMode());
    // Write color
    out->writeVec4(getColor());
}

void TexEnv::read(DataInputStream* in){
    // Peek on TexEnv's identification.
    int id = in->peekInt();
    if(id == IVETEXENV){
        // Read TexEnv's identification.
        id = in->readInt();
        // If the osg class is inherited by any other class we should also read this from file.
        osg::Object*  obj = dynamic_cast<osg::Object*>(this);
        if(obj){
            ((ive::Object*)(obj))->read(in);
        }
        else
            throw Exception("TexEnv::read(): Could not cast this osg::TexEnv to an osg::Object.");
        // Read TexEnv's properties

        // Read mode
        setMode((osg::TexEnv::Mode)in->readInt());
        // Read color
        setColor(in->readVec4());
    }
    else{
        throw Exception("TexEnv::read(): Expected TexEnv identification.");
    }
}
