#!/bin/sh -e

VERSION=$2
PACKAGE=$(dpkg-parsechangelog | sed -n 's/^Source: //p')
TARBALL=../${PACKAGE}_${VERSION}.orig.tar.gz
DIR=${PACKAGE}-${VERSION}

## objenesis-${VERSION}-bin.zip contains objenesis-${VERSION}-sources.jar
unzip -oj ../objenesis-${VERSION}-bin.zip objenesis-${VERSION}/objenesis-${VERSION}-sources.jar
mkdir $DIR
unzip -d $DIR objenesis-${VERSION}-sources.jar
## download pom from objenesis site and add it to tarball
wget -P $DIR http://objenesis.googlecode.com/svn/trunk/main/pom.xml
tar -zcvf $TARBALL $DIR
rm -rf $DIR objenesis-1.2-sources.jar ../objenesis-${VERSION}-bin.zip
