/* -*- Mode: C; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2007-2008 Tadas Dailyda <tadas@dailyda.com>
 *
 * Licensed under the GNU General Public License Version 2
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#ifndef __ODS_BLUEZ_H
#define __ODS_BLUEZ_H

#include <glib-object.h>
#include <dbus/dbus-glib.h>

G_BEGIN_DECLS

#define ODS_TYPE_BLUEZ		 (ods_bluez_get_type ())
#define ODS_BLUEZ(o)		 (G_TYPE_CHECK_INSTANCE_CAST ((o), ODS_TYPE_BLUEZ, OdsBluez))
#define ODS_BLUEZ_CLASS(k)	 (G_TYPE_CHECK_CLASS_CAST((k), ODS_TYPE_BLUEZ, OdsBluezClass))
#define ODS_IS_BLUEZ(o)		 (G_TYPE_CHECK_INSTANCE_TYPE ((o), ODS_TYPE_BLUEZ))
#define ODS_IS_BLUEZ_CLASS(k)  (G_TYPE_CHECK_CLASS_TYPE ((k), ODS_TYPE_BLUEZ))
#define ODS_BLUEZ_GET_CLASS(o) (G_TYPE_INSTANCE_GET_CLASS ((o), ODS_TYPE_BLUEZ, OdsBluezClass))

typedef struct OdsBluezPrivate OdsBluezPrivate;

typedef struct
{
	 GObject		 parent;
	 OdsBluezPrivate	*priv;
} OdsBluez;

typedef struct
{
	GObjectClass	parent_class;
	DBusGConnection *connection;
} OdsBluezClass;

typedef void (* OdsBluezFunc)	(gint, GError*, gpointer);

GType		 ods_bluez_get_type		  				(void);
OdsBluez	*ods_bluez_new							();
gboolean	 ods_bluez_is_initialized				(OdsBluez *bluez);
void		 ods_bluez_get_client_socket			(OdsBluez *bluez, 
														const gchar *address,
														const gchar *uuid,
														gint channel,
														OdsBluezFunc func,
														gpointer data);
gint		 ods_bluez_get_server_socket			(OdsBluez *bluez, 
														const gchar *address,
														guint8 channel);
guint32		 ods_bluez_add_service_record			(OdsBluez *bluez,
														const gchar *device,
														gint service);
void		 ods_bluez_remove_service_record		(OdsBluez *bluez,
														const gchar *device,
														guint32 record_handle);

G_END_DECLS

#endif /* __ODS_BLUEZ_H */
