/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.wsee;

import xdoclet.XDocletException;
import xdoclet.XmlSubTask;
import xdoclet.util.Translator;

/**
 * SubTask that generates the web-services.xml deployment descriptor.
 *
 * @author               Christoph G. Jung (christoph.jung@infor.de)
 * @created              23.12.03
 * @ant.element          display-name="webservices.xml" name="deploymentdescriptor"
 *      parent="xdoclet.modules.wsee.WseeDocletTask"
 * @version              $Revision: 1.3 $
 * @xdoclet.merge-file   file="custom-web-services.xml" relates-to="webservices.xml" description="An XML unparsed entity
 *      containing extensions to the defined web services."
 */
public class WebServicesXmlSubTask extends XmlSubTask
{
    /**
     * some constants
     */
    private static String DEFAULT_TEMPLATE_FILE =
        "resources/web-services_xml.xdt";
    private static String GENERATED_FILE_NAME = "webservices.xml";
    private static String XSD_SERVICES_11 =
        "http://java.sun.com/xml/ns/j2ee/j2ee_web_services_1_1.xsd";

    /**
     * state
     */
    protected String smallIcon = "";
    protected String largeIcon = "";
    protected String displayName = "";
    protected String description = "";
    protected String name;

    /**
     * initializes default output location and template names
     */
    public WebServicesXmlSubTask()
    {
        setTemplateURL(getClass().getResource(DEFAULT_TEMPLATE_FILE));
        setDestinationFile(GENERATED_FILE_NAME);
    }

    /**
     * Gets the Description attribute of the WebXmlSubTask object
     *
     * @return   The Description value
     */
    public String getDescription()
    {
        return description;
    }

    /**
     * @return   the display name of the webservice descriptor
     */
    public String getDisplayName()
    {
        return displayName;
    }

    /**
     * @return   large icon location
     */
    public String getLargeIcon()
    {
        return largeIcon;
    }

    /**
     * @return   id of the descriptor
     */
    public String getName()
    {
        return name;
    }

    /**
     * @return   small icon location
     */
    public String getSmallIcon()
    {
        return smallIcon;
    }

    /**
     * Sets the Description attribute of the WebXmlSubTask object
     *
     * @param description  The new Description value
     */
    public void setDescription(String description)
    {
        this.description = description;
    }

    /**
     * set display name
     *
     * @param string  name
     */
    public void setDisplayName(String string)
    {
        displayName = string;
    }

    /**
     * set large icon location
     *
     * @param string  location
     */
    public void setLargeIcon(String string)
    {
        largeIcon = string;
    }

    /**
     * set descriptor name
     *
     * @param string  name
     */
    public void setName(String string)
    {
        name = string;
    }

    /**
     * set small icon location
     *
     * @param string  location
     */
    public void setSmallIcon(String string)
    {
        smallIcon = string;
    }

    /**
     * runs the subtask
     *
     * @exception XDocletException
     */
    public void execute() throws XDocletException
    {
        setSchema(XSD_SERVICES_11);
        startProcess();
    }

    /**
     * feedback upon engine start
     *
     * @exception XDocletException
     */
    protected void engineStarted() throws XDocletException
    {
        System.out.println(
            Translator.getString(
            XDocletModulesMessages.class,
            XDocletModulesMessages.GENERATING_WEB_SERVICE_DESCRIPTOR,
            new String[]{getDestinationFile()}));
    }

}
