module REXML
	# A template for stream parser listeners.
	# Note that the declarations (attlistdecl, elementdecl, etc) are trivially
	# processed; REXML doesn't yet handle doctype entity declarations, so you 
	# have to parse them out yourself.
	module StreamListener
		# Called when a tag is encountered.
		# @p name the tag name
		# @p attrs an array of arrays of attribute/value pairs, suitable for
		# use with assoc or rassoc.  IE, <tag attr1="value1" attr2="value2">
		# will result in 
		# tag_start( "tag", # [["attr1","value1"],["attr2","value2"]])
		def tag_start name, attrs
		end
		# Called when the end tag is reached.  In the case of <tag/>, tag_end
		# will be called immidiately after tag_start
		# @p the name of the tag
		def tag_end name
		end
		# Called when text is encountered in the document
		# @p text the text content.
		def text text
		end
		# Called when an instruction is encountered.  EG: <?xsl sheet='foo'?>
		# @p name the instruction name; in the example, "xsl"
		# @p instruction the rest of the instruction.  In the example,
		# "sheet='foo'"
		def instruction name, instruction
		end
		# Called when a comment is encountered.
		# @p comment The content of the comment
		def comment comment
		end
		# Handles a doctype declaration. Any attributes of the doctype which are
		# not supplied will be nil.  # EG, <!DOCTYPE me PUBLIC "foo" "bar">
		# @p name the name of the doctype; EG, "me"
		# @p pub_sys "PUBLIC", "SYSTEM", or nil.  EG, "PUBLIC"
		# @p long_name the supplied long name, or nil.  EG, "foo"
		# @p uri the uri of the doctype, or nil.  EG, "bar"
		def doctype name, pub_sys, long_name, uri
		end
		# If a doctype includes an ATTLIST declaration, it will cause this
		# method to be called.  The content is the declaration itself, unparsed.
		# EG, <!ATTLIST el attr CDATA #REQUIRED> will come to this method as "el
		# attr CDATA #REQUIRED".  This is the same for all of the .*decl
		# methods.
		def attlistdecl content
		end
		# <!ELEMENT ...>
		def elementdecl content
		end
		# <!ENTITY ...>
		def entitydecl content
		end
		# <!NOTATION ...>
		def notationdecl content
		end
		# Called when %foo; is encountered in a doctype declaration.
		# @p content "foo"
		def entity content
		end
		# Called when <![CDATA[ ... ]]> is encountered in a document.
		# @p content "..."
		def cdata content
		end
		# Called when an XML PI is encountered in the document.
		# EG: <?xml version="1.0" encoding="utf"?>
		# @p version the version attribute value.  EG, "1.0"
		# @p encoding the encoding attribute value, or nil.  EG, "utf"
		# @p standalone the standalone attribute value, or nil.  EG, nil
		def xmldecl version, encoding, standalone
		end
	end
end
