/*-------------------------------------------------------------------------
*
* Copyright (c) 2009-2011, PostgreSQL Global Development Group
*
* IDENTIFICATION
*   $PostgreSQL: pgjdbc/org/postgresql/xa/PGXAException.java,v 1.3 2011/08/02 20:26:01 davecramer Exp $
*
*-------------------------------------------------------------------------
*/
package org.postgresql.xa;

import javax.transaction.xa.XAException;

/**
 * A convenience subclass of <code>XAException</code> which makes it easy to
 * create an instance of <code>XAException</code> with a human-readable
 * message, a <code>Throwable</code> cause, and an XA error code.
 * 
 * @author Michael S. Allman
 */
public class PGXAException extends XAException {
    PGXAException(String message, int errorCode) {
        super(message);

        this.errorCode = errorCode;
    }

    PGXAException(String message, Throwable cause, int errorCode) {
        super(message);

        initCause(cause);
        this.errorCode = errorCode;
    }

    PGXAException(Throwable cause, int errorCode) {
        super(errorCode);

        initCause(cause);
    }
}
