#include "osl/record/opening/openingBook.h"
#include "osl/state/simpleState.h"
#include "osl/apply_move/applyMove.h"
#include "osl/record/csa.h"
#include "osl/record/csaRecord.h"
#include "osl/stl/hash_map.h"
#include "osl/hash/hashKey.h"

#include <iostream>

using namespace osl;
using namespace osl::record;
using namespace osl::record::opening;
using namespace osl::stl;

struct HashSimpleState
{
  unsigned long operator() (const osl::state::SimpleState &state) const
  {
    return osl::hash::HashKey(state).signature();
  }
};

int main(int argc, char **argv)
{
  std::string book_filename = "../data/joseki.dat";
  WeightedBook book(book_filename.c_str());

  typedef hash_map<SimpleState, WeightedBook::WMoveContainer,
    HashSimpleState> state_map;

  state_map states;
  {
    std::vector<int> state_stack;
    state_stack.push_back(book.getStartState());

    while (!state_stack.empty())
    {
      const int index = state_stack.back();
      state_stack.pop_back();

      const SimpleState state = book.getBoard(index);
      if (states.find(state) == states.end())
      {
	WeightedBook::WMoveContainer moves = book.getMoves(index);
	for (size_t i = 0; i < moves.size(); ++i)
	{
	  state_stack.push_back(moves[i].getStateIndex());
	}
	states[state] = moves;
      }
    }
  }

  for (int i = 1; i < argc; ++i)
  {
    const std::string filename(argv[i]);
    osl::record::csa::CsaFile csa(filename);

    const SimpleState state = csa.getInitialState();
    state_map::const_iterator it = states.find(state);
    if (it == states.end())
    {
      std::cout << filename << "\t" << "Not found" << std::endl;
    }
    else
    {
      std::cout << filename;
      const WeightedBook::WMoveContainer &moves = it->second;
      for (size_t j = 0; j < moves.size(); ++j)
      {
	std::cout << "\t" << osl::record::csa::show(moves[j].getMove())
		  << "\t" << moves[j].getWeight();
      }
      std::cout << std::endl;
    }
  }

  return 0;
}
