$:.unshift "../lib"

require 'test/unit'
require 'needle'
require 'needle/extras/multicast'

class TC_Multicast_Target < Test::Unit::TestCase

  def test_empty_delegation
    target = Needle::Extras::Multicast::Target.new
    assert_equal [], target.length
  end

  def test_non_empty_delegation
    target = Needle::Extras::Multicast::Target.new( "foo", "bar baz",
      [ 1, 2, 3, 4, 5 ] )
    assert_equal [ 3, 7, 5 ], target.length
  end

  def test_send_bad_message
    target = Needle::Extras::Multicast::Target.new( 5 )
    assert_raise( NoMethodError ) do
      target.length
    end
  end

end

class TC_Multicast_Service < Test::Unit::TestCase

  def test_service
    reg = Needle::Registry.define do |b|
      b.require 'needle/extras/multicast', Needle::Extras::Multicast

      b.a { "a" }
      b.b { "b" }
      b.c { |c,| [ c.a, c.b, "c" ] }

      b.sender { |c,| c.multicast( c.a, c.c ) }
    end

    sender = reg.sender
    assert_equal [ 1, 3 ], sender.length
  end

end
