/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package javax.management;

import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.InstanceNotFoundException;

/**
 * This interface is implemented by MBeans that are able to make themselves persistent.
 *
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.4 $
 */
public interface PersistentMBean
{
   /**
    * Loads a previously saved MBean state into the MBean itself.
    *
    * @throws MBeanException If an exception occurred during loading or if loading is not supported.
    * @throws InstanceNotFoundException If some MBean needed for loading is not found.
    * @see #store
    */
   public void load() throws MBeanException, InstanceNotFoundException, RuntimeOperationsException;

   /**
    * Stores the MBean state into a persistent media.
    *
    * @throws MBeanException If an exception occurred during storing or if storing is not supported.
    * @throws InstanceNotFoundException If some MBean needed for storing is not found.
    */
   public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException;
}
