/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import jdepend.framework.FileManager;
import jdepend.framework.JDependTestCase;

public class FileManagerTest
extends JDependTestCase {
    private FileManager fileManager;

    public FileManagerTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        this.fileManager = new FileManager();
        this.fileManager.acceptInnerClasses(false);
    }

    protected void tearDown() {
        super.tearDown();
    }

    public void testEmptyFileManager() {
        FileManagerTest.assertEquals((int)0, (int)this.fileManager.extractFiles().size());
    }

    public void testBuildDirectory() throws IOException {
        this.fileManager.addDirectory(this.getBuildDir());
        FileManagerTest.assertEquals((int)39, (int)this.fileManager.extractFiles().size());
    }

    public void testNonExistentDirectory() {
        try {
            this.fileManager.addDirectory(this.getBuildDir() + "junk");
            FileManagerTest.fail((String)"Non-existent directory: Should raise IOException");
        }
        catch (IOException expected) {
            FileManagerTest.assertTrue((boolean)true);
        }
    }

    public void testInvalidDirectory() {
        String file = this.getTestDir() + this.getPackageSubDir() + "ExampleTest.java";
        try {
            this.fileManager.addDirectory(file);
            FileManagerTest.fail((String)"Invalid directory: Should raise IOException");
        }
        catch (IOException expected) {
            FileManagerTest.assertTrue((boolean)true);
        }
    }

    public void testClassFile() throws IOException {
        File f = new File(this.getBuildDir() + this.getPackageSubDir() + "JDepend.class");
        FileManagerTest.assertEquals((boolean)true, (boolean)new FileManager().acceptClassFile(f));
    }

    public void testNonExistentClassFile() {
        File f = new File(this.getBuildDir() + "JDepend.class");
        FileManagerTest.assertEquals((boolean)false, (boolean)new FileManager().acceptClassFile(f));
    }

    public void testInvalidClassFile() {
        File f = new File(this.getHomeDir() + "build.xml");
        FileManagerTest.assertEquals((boolean)false, (boolean)new FileManager().acceptClassFile(f));
    }

    public void testJar() throws IOException {
        File f = File.createTempFile("bogus", ".jar", new File(this.getTestDataDir()));
        this.fileManager.addDirectory(f.getPath());
        f.deleteOnExit();
    }

    public void testZip() throws IOException {
        File f = File.createTempFile("bogus", ".zip", new File(this.getTestDataDir()));
        this.fileManager.addDirectory(f.getPath());
        f.deleteOnExit();
    }

    public void testWar() throws IOException {
        File f = File.createTempFile("bogus", ".war", new File(this.getTestDataDir()));
        this.fileManager.addDirectory(f.getPath());
        f.deleteOnExit();
    }
}

