/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.io.IOException;
import java.io.InputStream;

final class SQLServerClobAsciiInputStream
extends InputStream {
    private SQLServerClob parentClob = null;
    private long streamPos;
    private long markPos;
    private byte[] bSingleByte = new byte[1];

    SQLServerClobAsciiInputStream(SQLServerClob sQLServerClob) {
        this.parentClob = sQLServerClob;
        this.streamPos = 0L;
        this.markPos = 0L;
    }

    private boolean isEOS() throws IOException {
        return this.streamPos >= this.getClobCharLength();
    }

    private long getClobCharLength() throws IOException {
        try {
            return this.parentClob.length();
        }
        catch (SQLServerException sQLServerException) {
            throw new IOException(sQLServerException.getMessage());
        }
    }

    private void checkClosed() throws IOException {
        if (null == this.parentClob) {
            throw new IOException(SQLServerException.getErrString("R_streamIsClosed"));
        }
    }

    public long skip(long l) throws IOException {
        this.checkClosed();
        if (l < 0L) {
            return 0L;
        }
        if (this.isEOS()) {
            return 0L;
        }
        long l2 = this.getClobCharLength();
        if (0L == l2) {
            return 0L;
        }
        if (this.streamPos >= l2) {
            return 0L;
        }
        if (l > l2 - this.streamPos) {
            long l3 = l2 - this.streamPos;
            this.streamPos = l2;
            return l3;
        }
        this.streamPos += l;
        return l;
    }

    public int available() throws IOException {
        this.checkClosed();
        if (this.isEOS()) {
            return 0;
        }
        long l = this.getClobCharLength();
        if (0L == l) {
            return 0;
        }
        if (this.streamPos >= l) {
            return 0;
        }
        return (int)(l - this.streamPos);
    }

    public int read() throws IOException {
        this.checkClosed();
        if (this.isEOS()) {
            return -1;
        }
        int n = this.read(this.bSingleByte, 0, 1);
        return 0 == n ? -1 : this.bSingleByte[0] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        this.checkClosed();
        if (null == byArray) {
            return 0;
        }
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.checkClosed();
        if (null == byArray) {
            return 0;
        }
        if (this.isEOS()) {
            return -1;
        }
        int n3 = this.parentClob.read((int)this.streamPos, byArray, n, n2);
        this.streamPos += (long)n3;
        return n3;
    }

    public void mark(int n) {
        this.markPos = this.streamPos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        this.checkClosed();
        this.parentClob = null;
    }

    public void reset() throws IOException {
        this.checkClosed();
        this.streamPos = this.markPos;
    }
}

