/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: RuleElement.cpp,v 1.3 2004/09/12 01:05:54 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <assert.h>

#include <fwbuilder/libfwbuilder-config.h>

#include <fwbuilder/FWObjectDatabase.h>
#include <fwbuilder/RuleElement.h>

#include <fwbuilder/IPService.h>
#include <fwbuilder/Interval.h>

#include <fwbuilder/FWObjectReference.h>
#include <fwbuilder/FWServiceReference.h>
#include <fwbuilder/FWIntervalReference.h>

#include <fwbuilder/XMLTools.h>

using namespace std;
using namespace libfwbuilder;

const char *RuleElement::TYPENAME={"RuleElement"};

RuleElement::RuleElement() 
{
    remStr("comment");
    remStr("name");
    remStr("id");

    setBool("neg",false);
}

RuleElement::RuleElement(const FWObject *root)
{
    remStr("comment");
    remStr("name");
    remStr("id");

    setBool("neg",false);
}

void RuleElement::fromXML(xmlNodePtr root) throw(FWException)
{
    const char *n;

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("neg")));
    if(n)
    {
        setStr("neg",n);
        FREEXMLBUFF(n);
    }

    FWObject::fromXML(root);
}

void RuleElement::addRef(FWObject *obj)
{
    FWObject *o=NULL;
    if (isAny()) {
	o=(*(begin()));
	o=(FWReference::cast(o))->getPointer();
    }
    FWObject::addRef(obj);
    if (o!=NULL) removeRef(o);
}

void RuleElement::removeRef(FWObject *obj)
{
    FWObject::removeRef(obj);
    
    if (getChildrenCount()==0) {   // there is nothing left
	obj=obj->getRoot()->getById( getAnyElementId() , true );
	if (obj)  {
	    addRef(obj);
	}
    }
}

bool RuleElement::isAny()
{
    if (getChildrenCount()!=1) return(false);

    FWObject *o;
    list<FWObject*>::iterator m=begin();
    if (  (o=(*m))!=NULL ) 
    {
	if ( FWObjectReference::isA(o) ||
	     FWServiceReference::isA(o) ||
	     FWIntervalReference::isA(o) ) 
        {
	    if ((FWReference::cast(o))->getPointerId()==getAnyElementId()) return(true);
	}
    }
    return(false);
}


void RuleElement::setAnyElement()
{
    string any_id=getAnyElementId();
    
    FWObject *any=getRoot()->getById( any_id , true );
    if (any) 
	addRef( any );
}

void RuleElement::reset()
{
    clearChildren();
    setAnyElement();
    setNeg(false);
}

/*
 * special method, it is being called from constructor with a
 * parameter 'root' to initialize rule element with appropriate
 * reference to any
 *
 * this method is intended for internal use only
 */
void RuleElement::_initialize(const FWObject *root)
{
    string any_id=getAnyElementId();
    FWObject *any_obj=((FWObjectDatabase*)root)->getById(any_id,true);
    assert (any_obj!=NULL);
    FWObject::addRef( any_obj );
}

string RuleElement::getAnyElementId()
{
    return "";
}

/*
 *   Meaning of "source","destination" and "service" can be negated
 */
bool RuleElement::getNeg()
{
    return ( getBool("neg") );
}

void RuleElement::setNeg(bool f) 
{ 
    if (!empty()) setBool("neg",f);
    else          setBool("neg",false);  // it does not make sence to negate nothing
}

void RuleElement::toggleNeg()
{ 
    bool n;
    n=getBool("neg");
    if (!empty()) setBool("neg",!n );
    else          setBool("neg",false);  // it does not make sence to negate nothing
}

const char *RuleElementSrc::TYPENAME={"Src"};
RuleElementSrc::RuleElementSrc() {}
RuleElementSrc::RuleElementSrc(const FWObject *root) : RuleElement(root) 
{
    _initialize(root);
}

string RuleElementSrc::getAnyElementId() {
    return FWObjectDatabase::db->getAnyNetworkId();
}



const char *RuleElementDst::TYPENAME={"Dst"};
RuleElementDst::RuleElementDst() {}
RuleElementDst::RuleElementDst(const FWObject *root) : RuleElement(root)
{
    _initialize(root);
}

string RuleElementDst::getAnyElementId() {
    return FWObjectDatabase::db->getAnyNetworkId();
}



const char *RuleElementSrv::TYPENAME={"Srv"};
RuleElementSrv::RuleElementSrv() {}
RuleElementSrv::RuleElementSrv(const FWObject *root) : RuleElement(root)
{
    _initialize(root);
}


string RuleElementSrv::getAnyElementId() {
    return FWObjectDatabase::db->getAnyIPServiceId();
}




const char *RuleElementOSrc::TYPENAME={"OSrc"};
RuleElementOSrc::RuleElementOSrc() {}
RuleElementOSrc::RuleElementOSrc(const FWObject *root) : RuleElement(root)
{
    _initialize(root);
}

string RuleElementOSrc::getAnyElementId() {
    return FWObjectDatabase::db->getAnyNetworkId();
}


const char *RuleElementODst::TYPENAME={"ODst"};
RuleElementODst::RuleElementODst() {}
RuleElementODst::RuleElementODst(const FWObject *root) : RuleElement(root)
{
    _initialize(root);
}

string RuleElementODst::getAnyElementId() {
    return FWObjectDatabase::db->getAnyNetworkId();
}


const char *RuleElementOSrv::TYPENAME={"OSrv"};
RuleElementOSrv::RuleElementOSrv() {}
RuleElementOSrv::RuleElementOSrv(const FWObject *root) : RuleElement(root)
{
    _initialize(root);
}

string RuleElementOSrv::getAnyElementId() {
    return FWObjectDatabase::db->getAnyIPServiceId();
}




const char *RuleElementTSrc::TYPENAME={"TSrc"};
RuleElementTSrc::RuleElementTSrc() {}
RuleElementTSrc::RuleElementTSrc(const FWObject *root) : RuleElement(root)
{
    _initialize(root);
}

string RuleElementTSrc::getAnyElementId() {
    return FWObjectDatabase::db->getAnyNetworkId();
}


const char *RuleElementTDst::TYPENAME={"TDst"};
RuleElementTDst::RuleElementTDst() {}
RuleElementTDst::RuleElementTDst(const FWObject *root) : RuleElement(root)
{
    _initialize(root);
}

string RuleElementTDst::getAnyElementId() {
    return FWObjectDatabase::db->getAnyNetworkId();
}


const char *RuleElementTSrv::TYPENAME={"TSrv"};
RuleElementTSrv::RuleElementTSrv()  {}
RuleElementTSrv::RuleElementTSrv(const FWObject *root) : RuleElement(root)
{
    _initialize(root);
}

string RuleElementTSrv::getAnyElementId() {
    return FWObjectDatabase::db->getAnyIPServiceId();
}




const char *RuleElementInterval::TYPENAME={"When"};
RuleElementInterval::RuleElementInterval() {}
RuleElementInterval::RuleElementInterval(const FWObject *root) : RuleElement(root)
{
    _initialize(root);
}

string RuleElementInterval::getAnyElementId() {
    return FWObjectDatabase::db->getAnyIntervalId();
}















