/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include <stdlib.h>
#include <string.h>


/* -------------------------------------------------------
   Like strcat(), but adds linefeed if linelength exceeded
   ------------------------------------------------------- */

int strwrapcat(char *dest_str, char *src_str, int linelen, int maxlen)
{
  char *temp_ptr;

  if (!*src_str || !linelen || (strlen(src_str) >= linelen)) return(0);

  if ((strlen(src_str) + strlen(dest_str) + 3) >= maxlen) return(0);
  
  temp_ptr = strrchr(dest_str, '\n');
  if (!temp_ptr) temp_ptr = dest_str;
    
  if ((strlen(src_str) + (dest_str + strlen(dest_str) - temp_ptr)) > linelen)
    strcat(dest_str, "\n");

  strcat(dest_str, src_str);
  return(1);
}


