/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#ifndef _TTREE_H
#include "ttree.h"
#endif
#ifndef _SOCK_H
#include "sock.h"
#endif


/* Status values */

#define IRC_STAT_OK       0
#define IRC_STAT_ERR_NICK 1

#define IRC_STATE_OFFLINE 0
#define IRC_STATE_LOGIN 1
#define IRC_STATE_ONLINE 2

/* IRC protocol numerics */

#define IRC_RPL_INVITED           341

#define IRC_ERR_NONICKNAMEGIVEN   431
#define IRC_ERR_ERRONEUSNICKNAME  432
#define IRC_ERR_NICKNAMEINUSE     433
#define IRC_ERR_NICKCOLLISION     436

#define IRC_MSG_PING             1000
#define IRC_MSG_PRIV             1001
#define IRC_MSG_PUB              1002
#define IRC_MSG_NOTICE           1003
#define IRC_MSG_JOIN             1004
#define IRC_MSG_PART             1005
#define IRC_MSG_QUIT             1006
#define IRC_MSG_KICK             1007
#define IRC_MSG_INVITATION       1008
#define IRC_MSG_TOPIC            1009
#define IRC_MSG_NICK             1010
#define IRC_MSG_MODE             1011
#define IRC_MSG_ERROR            1012
#define IRC_MSG_UNKNOWN          1013

typedef struct
{
  /* Client */
  char *nick;
  char *name;
  char *login;
  char *client_host;

  /* Server */
  char *server;
  unsigned short port;

  /* Connection */
  SOCK *s;
  int status;  /* Status of last operation */
  int state;   /* Session state */

  /* Data */
  TTREE *q;    /* Block queue */
  TTREE *nicks_preferred;
}
IRC;

typedef struct
{
  short num;
  short tok_num;
  char **tok;
  char *msg;
  char *str;
}
IRC_BLK;

/* Prototypes */

IRC *irc_new(TTREE *nicks_preferred, char *name, char *login, char *client_host);
void irc_free(IRC *irc);
int irc_login(IRC *irc, char *server, unsigned short port);
void irc_send(IRC *irc, char *format, ...);
char *irc_recv(IRC *irc);
void irc_blk_print(IRC_BLK *blk);
void irc_blk_free(IRC_BLK *blk);
void irc_blk_queue(IRC *irc, IRC_BLK *blk);
void irc_queue_empty(IRC *irc);
IRC_BLK *irc_wait_num_list(IRC *irc, short num, ...);
int irc_set_nick(IRC *irc, char *nick);
int irc_set_user(IRC *irc, char *server);
int irc_internal(IRC *irc, IRC_BLK *blk);
IRC_BLK *irc_blk_get(IRC *irc);
int irc_blk_hook(IRC *irc);
