/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.xmlrpc;

import java.text.ParseException;
import java.util.Date;

/**
 * This class uses tests the XmlRpcDateFormatTest for proper behavior.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class XmlRpcDateFormatTest
	extends junit.framework.TestCase
{

	public XmlRpcDateFormatTest(String name) {
		super(name);
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(XmlRpcDateFormatTest.class);
	}

	public void test() 
		throws Exception
	{
		XmlRpcDateFormat format = new XmlRpcDateFormat();
		try {
			Date d = format.parse("xxxxxxxxxxx");
			fail("Should fail on bad date parse");
		} catch (ParseException pe) {
		}
		String s = "20000101T04:01:01";
		Date d = null;
		try {
			d = format.parse(s);
		} catch (ParseException pe) {
			fail("Shouldn't fail on good date parse " + pe);
		}
		String s2 = format.format(d);
		assertEquals(s, s2);
	}
}
