#define iter( cl ) \
%mixin cl "Enumerable"; \
%extend cl { \
    void each() { \
        cl::iterator i = self->begin(); \
        while ( i != self->end() ) { \
            rb_yield( SWIG_NewPointerObj( (void *) &*i, $descriptor(cl::iterator::value_type *), 1)); \
            ++i; \
        } \
    } \
}

%define range( T )
%mixin wibble::Range< T > "Enumerable";
%extend wibble::Range< T > {
        void each() {
            wibble::Range< T >::iterator i = self->begin();
            while ( i != self->end() ) { \
                rb_yield( SWIG_NewPointerObj( (void *) new T( *i ), $descriptor(T *), 1) ); \
                ++i;
            }
        }
    }
%enddef

%define wrap_set( T )
%mixin std::set< T > "Enumerable";
%extend std::set< T > {
        void each() {
            std::set< T >::iterator i = self->begin();
            while ( i != self->end() ) { \
                rb_yield( SWIG_NewPointerObj( (void *) new T( *i ), $descriptor(T *), 1) ); \
                ++i;
            }
        }
    }
%enddef
