// -*- mode: c++; tab-width: 4; indent-tabs-mode: t -*-
/*
 * id->package mapping
 *
 * Copyright (C) 2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <ept/tests/test-utils.h>
#include <ept/cache/debtags/pkgidx.h>
#include <ept/forward.h>

using namespace ept::configuration;
using namespace ept::t::cache::debtags;

namespace tut {

struct cache_debtags_pkgidx_shar : common {
	typedef apt::cache::Packages Packages;
	cache_debtags_pkgidx_shar() : pkgidx(apt) {}
	PkgIdx<Apt> pkgidx;
};
TESTGRP(cache_debtags_pkgidx);

// Check that we can go from package to ID and back
template<> template<>
void to::test< 1 >()
{
	int x = 0;
	for (apt::cache::Index::iterator i = apt.index().begin();
		 i != apt.index().end(); ++i)
	{
		int id = i->ondiskId();
		std::string name = pkgidx.name(id);
		ensure_equals(i->name(), name);
		apt::cache::Package p = apt.index().packageByName(name);
		ensure_equals(p.ondiskId(), id);

		/* std::cerr << x << ": " << i->id() << ": "
				  << i->name() << ", " << pkgidx().name( i->id() ) <<
				  std::endl; */
		++ x;
	}
}

// Check that IDs are distinct
template<> template<>
void to::test< 2 >()
{
	using namespace std;

	size_t count = 0;
	set<int> ids;
	for (apt::cache::Index::iterator i = apt.index().begin();
		 i != apt.index().end(); ++i, ++count)
		ids.insert(i->ondiskId());
	ensure_equals(ids.size(), count);
}

}

// vim:set ts=4 sw=4:
