/** -*- C++ -*-
    @file cache/cache.h
    @author Peter Rockai <me@mornfall.net>
*/

#include <wibble/amorph.h>
#include <wibble/range.h>
#include <wibble/cast.h>

#include <ept/forward.h>
#include <ept/cache/component.h>
#include <ept/cache/apt/packages.h>

#ifndef EPT_CACHE_H
#define EPT_CACHE_H

namespace ept {
namespace t {
namespace cache {

struct Cache;

#if 0
/**
   @brief A singleton Cache keeper object.

   You can use Global::getPointer() if your program only needs a single
   Cache instance (which is the case in probably 90% of
   scenarios). This will relieve you of passing the Cache pointer
   around, since all classes taking a Cache pointer should use
   CacheGlobal::getPointer() on it, thus allowing 0 as a pointer to the
   global cache.
*/
struct Global {
protected:
    static Cache *s_cache;
public:
    /// Re-set the global cache to a different instance.
    static void setCache(Cache *c);

    /**
       @brief Get a cache pointer.

       This function will return the reference to object you pass as
       an argument in the case it's non-NULL, but will return the
       global cache pointer otherwise. This allows you to implement
       behaviour you can see in libapt-front itself, where passing 0
       as a Cache pointer causes the relevant object to use a global
       instance.
    */
    static Cache &get(Cache *my = 0);

    /**
       @brief Get a cache reference.

       Same as get(Cache *), but returns a pointer.
    */
    static Cache *getPointer(Cache *my = 0);
};
#endif

}
}
}

#endif
