/** -*- C++ -*-
	@file predicate/factory.h
	@author Peter Rockai <me@mornfall.net>
*/

#include <ept/actor/actor.h>
#include <ept/forward.h>

#ifndef EPT_ACTOR_FACTORY_H
#define EPT_ACTOR_FACTORY_H

namespace ept {
namespace actor {

template< typename T >
struct Factory {
    typedef MemberActor< T > Actor;

    static Actor install() {
        return Actor( &T::markInstall );
    }

    static Actor remove() {
        return Actor( &T::markRemove );
    }

    static Actor upgrade() {
        return Actor( &T::markInstall );
    }

    static Actor keep( ) {
        return Actor( &T::markKeep );
    }

    template< typename P >
    static Actor member( P func ) {
        return Actor( func );
    }

};

}
}


#endif
