/* 
 * Copyright (C) 2001-2003 Jacek Sieka, j_s@telia.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _HASH_VALUE
#define _HASH_VALUE

#ifndef _MSC_VER
#define _MSC_VER 0
#endif

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

template<class Hasher>
struct HashValue {
//	static const size_t SIZE = Hasher::HASH_SIZE;

	HashValue() { };
	HashValue(uint8_t* aData) { memcpy(data, aData, Hasher::HASH_SIZE); }
	HashValue(const string& base32) { Encoder::fromBase32(base32.c_str(), data, Hasher::HASH_SIZE); };
	HashValue(const HashValue& rhs) { memcpy(data, rhs.data, Hasher::HASH_SIZE); }
	HashValue& operator=(const HashValue& rhs) { memcpy(data, rhs.data, Hasher::HASH_SIZE); return *this; }
	bool operator==(const HashValue& rhs) const { return memcmp(data, rhs.data, Hasher::HASH_SIZE) == 0; }
	bool operator<(const HashValue& rhs) const { return memcmp(data, rhs.data, Hasher::HASH_SIZE) < 0; }

	string toBase32() { return Encoder::toBase32(data, Hasher::HASH_SIZE); };
	string& toBase32(string& tmp) { return Encoder::toBase32(data, Hasher::HASH_SIZE, tmp); };

	uint8_t data[Hasher::HASH_SIZE];
};

#endif // _HASH_VALUE

/**
* @file
* $Id: HashValue.h,v 1.3 2005/03/25 08:51:01 mathen Exp $
*/
