/* 
 * $Id: ctktable.h,v 1.12 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef __CTKTABLE_H__
# define __CTKTABLE_H__ 

typedef struct CtkTableAxis_S
{
	gboolean   canGrow;
	gint       hard_size;
	gint       accumSize;
} CtkTableAxis;

typedef struct CtkTableHeterogeneous_S
{
	CtkTableAxis* x;
	CtkTableAxis* y;
	
	/* We need fast insert, remove, walk */
	GTree* xstop;
	GTree* ystop;
} CtkTableHeterogeneous;

typedef struct CtkTableHomogeneous_S
{
	gint min_col_size;
	gint min_row_size;
} CtkTableHomogeneous;

typedef struct CtkTable_S
{
	CtkContainer container;
	
	gboolean homogeneous;
	gint     row_spacing;
	gint     col_spacing;
	gint     rows;
	gint     cols;
	
	union layout_S
	{
		CtkTableHeterogeneous hetero;
		CtkTableHomogeneous   homo;
	} layout;
} CtkTable;

void ctk_table_init(CtkTable *table, guint rows, guint cols, gboolean homogeneous);

CtkWidget *ctk_table_new(guint rows, guint columns, gboolean homogeneous);
void ctk_table_attach(CtkTable *table,
		      CtkWidget *child,
		      guint left_attach,
		      guint right_attach,
		      guint top_attach,
		      guint bottom_attach,
		      CtkAttachOptions xoptions,
		      CtkAttachOptions yoptions,
		      guint xpadding,
		      guint ypadding);

CtkWidget * ctk_table_find_child(CtkTable *table,
				 guint left_attach,
				 guint right_attach,
				 guint top_attach,
				 guint bottom_attach);

void ctk_table_set_row_spacings(CtkTable *table, gint spacings);
void ctk_table_set_col_spacings(CtkTable *table, gint spacings);

#define CTK_TABLE(obj)	CTK_CHECK_CAST((obj),CtkTable,CtkTypeTable)

void ctk_table_insert_row(CtkTable* table, gint row);
void ctk_table_insert_col(CtkTable* table, gint col);
void ctk_table_colour_row(CtkTable* table, gint row, gint colour);
void ctk_table_column_hard_size(CtkTable* table, gint col, gint size);
void ctk_table_delete_row(CtkTable* table, gint row);
void ctk_table_delete_below_row(CtkTable* table, gint row);
void ctk_table_detach(CtkTable* table, CtkWidget* child);

void ctk_table_real_size(CtkWidget* widget);
void ctk_table_min_size (CtkWidget* widget);

gint ctk_table_get_row_row(CtkTable* table, gint row);
gint ctk_table_get_col_col(CtkTable* table, gint col);
void ctk_table_get_click_cell(CtkTable* table, gint* row, gint* col, gint x, gint y);

#endif
