/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.commons.codec.net;

import junit.framework.TestCase;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.CharEncoding;

/**
 * RFC 1522 compliant codec test cases
 * 
 * @author <a href="mailto:oleg@ural.ru">Oleg Kalnichevski</a>
 * @version $Id: RFC1522CodecTest.java 798427 2009-07-28 07:32:09Z ggregory $
 */
public class RFC1522CodecTest extends TestCase {

    public RFC1522CodecTest(String name) {
        super(name);
    }

    static class RFC1522TestCodec extends RFC1522Codec {

        protected byte[] doDecoding(byte[] bytes) {
            return bytes;
        }

        protected byte[] doEncoding(byte[] bytes) {
            return bytes;
        }

        protected String getEncoding() {
            return "T";
        }

    }

    public void testNullInput() throws Exception {
        RFC1522TestCodec testcodec = new RFC1522TestCodec();
        assertNull(testcodec.decodeText(null));
        assertNull(testcodec.encodeText(null, CharEncoding.UTF_8));
    }

    private void assertExpectedDecoderException(String s) throws Exception {
        RFC1522TestCodec testcodec = new RFC1522TestCodec();
        try {
            testcodec.decodeText(s);
            fail("DecoderException should have been thrown");
        } catch (DecoderException e) {
            // Expected.
        }
    }

    public void testDecodeInvalid() throws Exception {
        assertExpectedDecoderException("whatever");
        assertExpectedDecoderException("=?");
        assertExpectedDecoderException("?=");
        assertExpectedDecoderException("==");
        assertExpectedDecoderException("=??=");
        assertExpectedDecoderException("=?stuff?=");
        assertExpectedDecoderException("=?UTF-8??=");
        assertExpectedDecoderException("=?UTF-8?stuff?=");
        assertExpectedDecoderException("=?UTF-8?T?stuff");
        assertExpectedDecoderException("=??T?stuff?=");
        assertExpectedDecoderException("=?UTF-8??stuff?=");
        assertExpectedDecoderException("=?UTF-8?W?stuff?=");
    }

}
