/*
    GNU LESSER GENERAL PUBLIC LICENSE
    Copyright (C) 2006 The XAMJ Project

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Contact info: lobochief@users.sourceforge.net
*/
package org.lobobrowser.html.style;

import java.awt.Insets;

import org.lobobrowser.html.domimpl.HTMLElementImpl;

public class ImageRenderState extends StyleSheetRenderState {
	public ImageRenderState(RenderState prevRenderState, HTMLElementImpl element) {
		super(prevRenderState, element);
	}

	public Insets getMarginInsets() {
		Insets mi = this.marginInsets;
		if(mi != INVALID_INSETS) {
			return mi;
		}
		AbstractCSS2Properties props = this.getCssProperties();
		if(props == null) { 
			mi = null;
		}
		else {
			mi = HtmlValues.getMarginInsets(props, this);
		}
		if(mi == null) {
			int hspace = 0;
			int vspace = 0;
			boolean createNew = false;
			String hspaceText = this.element.getAttribute("hspace");
			if(hspaceText != null && hspaceText.length() != 0) {
				createNew = true;
				try {
					hspace = Integer.parseInt(hspaceText);
				} catch(NumberFormatException nfe) {
					// TODO: Percentages?
				}
			}
			String vspaceText = this.element.getAttribute("vspace");
			if(vspaceText != null && vspaceText.length() != 0) {
				createNew = true;
				try {
					vspace = Integer.parseInt(vspaceText);
				} catch(NumberFormatException nfe) {
					// TODO: Percentages?
				}
			}
			if(createNew) {
				mi = new Insets(vspace, hspace, vspace, hspace);
			}
		}
		this.marginInsets = mi;
		return mi;
	}

	
}
