/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gtk;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;
/**
 * This is the base class of all widgets and a few non-widget objects.
 */
public class GtkObject extends GObject 
{
	
	protected GtkObject(int handle) {
		super(handle);
	}
	
	public void destroy() {
		gtk_object_destroy(getHandle());
	}
	
	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gtk_object_get_type());
	}

    /****************************************
     * BEGINNING OF GENERATED CODE
     ****************************************/
    native static final protected int getFlags (int obj);
    native static final protected void setFlags (int obj, int flags);
    native static final protected int gtk_object_get_type ();
    native static final protected void gtk_object_sink (int object);
    native static final protected void gtk_object_destroy (int object);
    /****************************************
     * END OF GENERATED CODE
     ****************************************/
}

