/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

#include <jni.h>
#include <libgnomevfs/gnome-vfs.h>

#ifndef _Included_org_gnu_gnomevfs_VFSDirectory
#define _Included_org_gnu_gnomevfs_VFSDirectory
#ifdef __cplusplus
extern "C" {
#endif

/*
 * Class:     org_gnu_gnomevfs_VFSDirectory
 * Method:    gnome_vfs_directory_open
 * Signature: ([ILjava/lang/String;I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSDirectory_gnome_1vfs_1directory_1open
  (JNIEnv *env, jclass cls, jintArray handle, jstring uri, jint options)
{
	const gchar* str = (*env)->GetStringUTFChars(env, uri, NULL);
	GnomeVFSDirectoryHandle *h;
	GnomeVFSResult result = gnome_vfs_directory_open(&h, str, (GnomeVFSFileInfoOptions)options);
	if (result == GNOME_VFS_OK)
		(*env)->SetIntArrayRegion(env, handle, 1, 1, (jint*)h);
	(*env)->ReleaseStringUTFChars(env, uri, str);
	return result;
}

/*
 * Class:     org_gnu_gnomevfs_VFSDirectory
 * Method:    gnome_vfs_directory_open_from_uri
 * Signature: ([III)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSDirectory_gnome_1vfs_1directory_1open_1from_1uri
  (JNIEnv *env, jclass cls, jintArray handle, jint uri, jint options)
{
	GnomeVFSDirectoryHandle *h;
	GnomeVFSResult result = gnome_vfs_directory_open_from_uri(&h, (GnomeVFSURI*)uri, (GnomeVFSFileInfoOptions)options);
	if (result == GNOME_VFS_OK)
		(*env)->SetIntArrayRegion(env, handle, 1, 1, (jint*)h);
	return result;
}

/*
 * Class:     org_gnu_gnomevfs_VFSDirectory
 * Method:    gnome_vfs_directory_read_next
 * Signature: (I[I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSDirectory_gnome_1vfs_1directory_1read_1next
  (JNIEnv *env, jclass cls, jint dir, jintArray info)
{
	GnomeVFSFileInfo *i = NULL;
	GnomeVFSResult result = gnome_vfs_directory_read_next((GnomeVFSDirectoryHandle*)dir, i);
	if (result == GNOME_VFS_OK)
		(*env)->SetIntArrayRegion(env, info, 1, 1, (jint*)i);
	return result;
	
}

/*
 * Class:     org_gnu_gnomevfs_VFSDirectory
 * Method:    gnome_vfs_directory_close
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSDirectory_gnome_1vfs_1directory_1close
  (JNIEnv *env, jclass cls, jint dir)
{
	return (jint)gnome_vfs_directory_close((GnomeVFSDirectoryHandle*)dir);
}

/*
 * Class:     org_gnu_gnomevfs_VFSDirectory
 * Method:    gnome_vfs_make_directory
 * Signature: (Ljava/lang/String;I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSDirectory_gnome_1vfs_1make_1directory
  (JNIEnv *env, jclass cls, jstring uri, jint perm)
{
	const gchar* str = (*env)->GetStringUTFChars(env, uri, NULL);
	jint result = (jint)gnome_vfs_make_directory(str, (guint)perm);
	(*env)->ReleaseStringUTFChars(env, uri, str);
	return result;
}

/*
 * Class:     org_gnu_gnomevfs_VFSDirectory
 * Method:    gnome_vfs_make_directory_for_uri
 * Signature: (II)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSDirectory_gnome_1vfs_1make_1directory_1for_1uri
  (JNIEnv *env, jclass cls, jint uri, jint perm)
{
	return (jint)gnome_vfs_make_directory_for_uri((GnomeVFSURI*)uri, (guint)perm);
}

/*
 * Class:     org_gnu_gnomevfs_VFSDirectory
 * Method:    gnome_vfs_remove_directory
 * Signature: (Ljava/lang/String;)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSDirectory_gnome_1vfs_1remove_1directory
  (JNIEnv *env, jclass cls, jstring uri)
{
	const gchar* str = (*env)->GetStringUTFChars(env, uri, NULL);
	jint result = (jint)gnome_vfs_remove_directory(str);
	(*env)->ReleaseStringUTFChars(env, uri, str);
	return result;
}

/*
 * Class:     org_gnu_gnomevfs_VFSDirectory
 * Method:    gnome_vfs_remove_directory_from_uri
 * Signature: (I)I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gnomevfs_VFSDirectory_gnome_1vfs_1remove_1directory_1from_1uri
  (JNIEnv *env, jclass cls, jint uri)
{
	return (jint)gnome_vfs_remove_directory_from_uri((GnomeVFSURI*)uri);
}

#ifdef __cplusplus
}
#endif
#endif
