/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */
package org.gnu.gnomevfs;

import org.gnu.glib.Flags;

/**
 * Mode in which files are opened. If RANDOM is not used the files must be
 * accessed sequentially.
 */
public class VFSOpenMode extends Flags {

    static final private int _NONE = 0;

    static final public VFSOpenMode NONE = new VFSOpenMode(_NONE);

    static final private int _READ = 1 << 0;

    static final public VFSOpenMode READ = new VFSOpenMode(_READ);

    static final private int _WRITE = 1 << 1;

    static final public VFSOpenMode WRITE = new VFSOpenMode(_WRITE);

    static final private int _RANDOM = 1 << 2;

    static final public VFSOpenMode RANDOM = new VFSOpenMode(_RANDOM);

    static final private VFSOpenMode[] theInterned = new VFSOpenMode[] { NONE,
            READ, WRITE, RANDOM };

    static private java.util.Hashtable theInternedExtras;

    static final private VFSOpenMode theSacrificialOne = new VFSOpenMode(0);

    static public VFSOpenMode intern(int value) {
        if (value < theInterned.length) {
            return theInterned[value];
        }
        theSacrificialOne.value_ = value;
        if (theInternedExtras == null) {
            theInternedExtras = new java.util.Hashtable();
        }
        VFSOpenMode already = (VFSOpenMode) theInternedExtras
                .get(theSacrificialOne);
        if (already == null) {
            already = new VFSOpenMode(value);
            theInternedExtras.put(already, already);
        }
        return already;
    }

    private VFSOpenMode(int value) {
        value_ = value;
    }

    public VFSOpenMode or(VFSOpenMode other) {
        return intern(value_ | other.value_);
    }

    public VFSOpenMode and(VFSOpenMode other) {
        return intern(value_ & other.value_);
    }

    public VFSOpenMode xor(VFSOpenMode other) {
        return intern(value_ ^ other.value_);
    }

    public boolean test(VFSOpenMode other) {
        return (value_ & other.value_) == other.value_;
    }
}