# Converts a Windows-1252 Euro to an ISO-8859-15 Euro.
# This should be obsolete, as Irssi supports UTF-8 correctly now.
# (mIRC doesn\'t, though. Who cares?)

# BTW, http://www.debian.org/doc/manuals/debian-euro-support/
# mIRC lusers: http://aku.ankka.com/euromirc.txt

use vars qw($VERSION %IRSSI);

$VERSION = '0.9';
%IRSSI = (
    authors     => 'Johan "Ion" Kiviniemi',
    contact     => 'ion at hassers.org',
    name        => 'Euro',
    description =>
'Converts a Windows-1252 Euro to an ISO-8859-15 Euro. This should be obsolete, as Irssi supports UTF-8 correctly now. (mIRC doesn\'t, though. Who cares?)',
    license => 'Public Domain',
    url     => 'http://ion.amigafin.org/irssi/',
    changed => 'Tue Mar 12 22:20 EET 2002',
);

use strict;
use warnings;
use Irssi;
use 5.6.0;

our $windows_euro = "\x80";                # Microsoft's souring.. Windows-1252?
our $real_euro    = "\xA4";                # ISO-8859-15 euro symbol
our $complaint    = " (euro converted)";   # Add this to the end of the line

Irssi::signal_add_first(
    "message public" => sub {
        return unless $_[1] =~ s/\Q$windows_euro\E/$real_euro/g;
        $_[1] .= $complaint;
        Irssi::signal_emit("message public", @_);
        Irssi::signal_stop();
    }
);

Irssi::signal_add_first(
    "message private" => sub {
        return unless $_[1] =~ s/\Q$windows_euro\E/$real_euro/g;
        $_[1] .= $complaint;
        Irssi::signal_emit("message private", @_);
        Irssi::signal_stop();
    }
);

Irssi::signal_add_first(
    "message part" => sub {
        return unless $_[4] =~ s/\Q$windows_euro\E/$real_euro/g;
        $_[4] .= $complaint;
        Irssi::signal_emit("message part", @_);
        Irssi::signal_stop();
    }
);

Irssi::signal_add_first(
    "message quit" => sub {
        return unless $_[3] =~ s/\Q$windows_euro\E/$real_euro/g;
        $_[3] .= $complaint;
        Irssi::signal_emit("message quit", @_);
        Irssi::signal_stop();
    }
);

Irssi::signal_add_first(
    "message kick" => sub {
        return unless $_[5] =~ s/\Q$windows_euro\E/$real_euro/g;
        $_[5] .= $complaint;
        Irssi::signal_emit("message kick", @_);
        Irssi::signal_stop();
    }
);

Irssi::signal_add_first(
    "message topic" => sub {
        return unless $_[2] =~ s/\Q$windows_euro\E/$real_euro/g;
        $_[2] .= $complaint;
        Irssi::signal_emit("message topic", @_);
        Irssi::signal_stop();
    }
);
