<?php
// File           tables.php / ibWebAdmin
// Purpose        acting with the tables of the selected database
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <00/09/05 23:02:00 lb>
//
// $Id: tables.php,v 1.26 2004/05/31 09:14:13 lbrueckner Exp $


require('inc/script_start.inc.php');

//
// script is called from the create table form
//
if (isset($HTTP_POST_VARS['tb_create_doit'])) {
    $s_create_table = $HTTP_POST_VARS['tb_create_table'];

    // this is the first step, $s_create_num is still unset
    if (!isset($s_create_num) || empty($s_create_num)) {
        
        if (isset($HTTP_POST_VARS['tb_create_num'])  &&  (int)$HTTP_POST_VARS['tb_create_num'] > 0) {
            $s_create_num = $HTTP_POST_VARS['tb_create_num'];
            $s_coldefs = array();
        }
    }

    // second step, get the column definitions,
    //              build the sql-statement and
    //              create the table 
    else {
        $rwords = array();
        for ($idx=0; $idx<$s_create_num; $idx++) {
            // save the form values into $s_coldefs
            save_coldef($idx);

            // interbase keywords are not allowed as column names 
            if (in_array(strtoupper($s_coldefs[$idx]['name']), get_reserved_words(SERVER_FAMILY, SERVER_VERSION))) {
                $rwords[] = strtoupper($s_coldefs[$idx]['name']);
            }
	}

        if (count($rwords) > 0) {
            $cnt = count($rwords);
            $warning = ($cnt == 1) ? sprintf($WARNINGS['NAME_IS_KEYWORD'], $rwords[0])
                                   : sprintf($WARNINGS['NAMES_ARE_KEYWORDS'], implode(', ',$rwords));
        }

        else {
	    // build the CREATE TABLE sql-statement
            $sql = "CREATE TABLE $s_create_table (\n";

	    // loop over the number of columns 
	    // and build the <col_def> parts of the query
	    for ($idx=0; $idx<$s_create_num; $idx++) {
	        $sql .= build_coldef($idx);

	        if (isset($s_coldefs[$idx]['primary'])) {   // collect fieldnames for the PRIMARY KEY
		    $pkeys[] = $s_coldefs[$idx]['name'];
	        }
	        $sql .= ",\n";
	    }
	    if (isset($pkeys)) {
	        $sql .= "\tPRIMARY KEY\t(".implode(', ', $pkeys)."),\n"; 
	    }
	    $sql = substr($sql, 0, -2);      // remove the last ',\n'
	    $sql .= "\n);";
        }
    }
}


//
// cancel button on the create table panel was pressed
//
if (isset($HTTP_POST_VARS['tb_create_cancel'])) {
    $s_create_num = '';
    $s_coldefs = array();
}



//
// script is called from the modify table form
//
if (isset($HTTP_POST_VARS['tb_modify_doit'])) {
    if ($HTTP_POST_VARS['tb_modify_name'] != '') {
	$s_modify_name = $HTTP_POST_VARS['tb_modify_name'];

        set_panel_title('tb_modify', $ptitle_strings['tb_modify'].': '.$s_modify_name);
    }
}


//
// script is called via the Ready button on the modify table form
//
if (isset($HTTP_POST_VARS['tb_modify_ready'])) {
    $s_modify_name = '';
    set_panel_title('tb_modify', $ptitle_strings['tb_modify']);
}


//
// script is called via the Add Column button on the modify table form
//
if (isset($HTTP_POST_VARS['tb_modify_add'])) {
    $s_coldefs['add'] = array();
    $col_add_flag = TRUE;
}


//
// add the new column to the table
//
if (isset($HTTP_POST_VARS['tb_modadd_doit'])) {
    save_coldef('add');

    // interbase keywords are not allowed as column names     
    if (in_array(strtoupper($s_coldefs['add']['name']), get_reserved_words(SERVER_FAMILY, SERVER_VERSION))) {
        $warning = sprintf($WARNINGS['NAME_IS_KEYWORD'], strtoupper($s_coldefs['add']['name']));

        // show the add-column form again
        $col_add_flag = TRUE;
    }

    else {
        $sql = "ALTER TABLE $s_modify_name ADD \n";
        $sql .= build_coldef('add', 'alter');
        $sql .= ';';

        $add_flag = TRUE;
    }
}


//
// script is called via the Delete Column button from the modify table form
//
if (isset($HTTP_POST_VARS['tb_modify_del'])
&&  isset($HTTP_POST_VARS['tb_modify_dname'])  &&  !empty($HTTP_POST_VARS['tb_modify_dname'])) {

    $cname = $HTTP_POST_VARS['tb_modify_dname'];

    $deps = get_dependencies(OT_RELATION, $s_modify_name, $cname);
    if (count($deps) > 0) {
        $message = sprintf($MESSAGES['HAVE_DEPENDENCIES'], $tb_strings['Column'], $cname, dependencies_string($deps));
    }

    else {
            $drop_statement = count(table_columns($s_modify_name)) > 1
                            ? 'ALTER TABLE '.$s_modify_name.' DROP '.$cname
                            : 'DROP TABLE '.$s_modify_name;

        if ($s_cust['askdel'] == TRUE) {
            $s_confirmations['column'] = 
                array('msg' => sprintf($MESSAGES['CONFIRM_COLUMN_DELETE'], $cname, $s_modify_name),
                      'sql' => $drop_statement);
        }
        else {
            $sql = $drop_statement;
        } 
    }
}


//
// script is called via the Modify Column button from the modify table form
//
if (isset($HTTP_POST_VARS['tb_modify_col'])
&&  isset($HTTP_POST_VARS['tb_modify_mname'])  &&  !empty($HTTP_POST_VARS['tb_modify_mname'])) {
    $s_modify_col = $HTTP_POST_VARS['tb_modify_mname'];
    foreach($s_fields as $idx => $field) {
        if ($field['table'] == $s_modify_name  &&  $field['name'] == $s_modify_col) {
            
            $s_coldefs['mod'] = $s_fields[$idx];

            if (isset($s_fields[$idx]['foreign'])) {
                $s_coldefs['mod'] 
                    = array_merge($s_coldefs['mod'],
                                  get_column_fk_defs($s_fields[$idx]['foreign'], $s_foreigns[$s_fields[$idx]['foreign']]['index']));
                $s_coldefs['mod']['foreign_cols'] = $s_foreigns[$s_fields[$idx]['foreign']]['cols'];
            }

            if (isset($s_fields[$idx]['primary'])) {
                $s_coldefs['mod']['primary_cols'] = $s_primaries[$s_fields[$idx]['primary']]['cols'];
            }

            if (isset($s_fields[$idx]['unique'])) {
                $s_coldefs['mod']['unique_cols'] = $s_uniques[$s_fields[$idx]['unique']]['cols'];
            }

            $s_coldefs['old'] = $s_coldefs['mod'];
            break;
	}
    }
    if (isset($s_coldefs['mod']['domain'])) {
        $warning = $WARNINGS['CAN_NOT_ALTER_DOMAINS'];
        $s_coldefs = array();
    }
    else {
        $s_coldefs['mod']['pk_del'] = $s_coldefs['mod']['fk_del'] = $s_coldefs['mod']['uq_del'] = FALSE;
        $col_mod_flag = TRUE;

        if ($s_use_jsrs === TRUE) {
            $js_stack .= js_jsrs_table_columns();
        }
    }
}


//
// altering the column definitions 
//
if (isset($HTTP_POST_VARS['tb_modcol_doit'])) {
    $mod_flag = FALSE;
    $sql = 'ALTER TABLE '.$s_modify_name.' ';

    save_coldef('mod');

    if (!isset($s_coldefs['mod']['domain'])  ||  $s_coldefs['mod']['domain'] != 'Yes') {

//         debug_var($s_coldefs['old']);
//         debug_var($s_coldefs['mod']);

        if (datatype_is_modified($s_coldefs['old'], $s_coldefs['mod'])) {

            // build sql for altering datatype definition
            $sql .= 'ALTER '.$s_modify_col.' TYPE ' . build_datatype($s_coldefs['mod']) . ', ';
            $mod_flag = TRUE;
        }

        // the delete primary key checkbox is checked
        if ($s_coldefs['mod']['pk_del'] == TRUE) {
            $sql .= 'DROP CONSTRAINT '.$s_coldefs['old']['primary'].', ';
            $mod_flag = TRUE;
        }

        // the delete foreign key checkbox is checked
        if ($s_coldefs['mod']['fk_del'] == TRUE) {
            $sql .= 'DROP CONSTRAINT '.$s_coldefs['old']['fk_name'].', ';
            $mod_flag = TRUE;
        }

        // the delete unique constraint checkbox is checked
        if ($s_coldefs['mod']['uq_del'] == TRUE) {
            $sql .= 'DROP CONSTRAINT '.$s_coldefs['old']['unique'].', ';
            $mod_flag = TRUE;
        }

        // delete and recreate the foreign key constraint
        elseif (column_fk_is_modified($s_coldefs['old'], $s_coldefs['mod'])) {

            if (isset($s_coldefs['old']['fk_name'])  &&  !empty($s_coldefs['old']['fk_name'])) {
                $sql .= 'DROP CONSTRAINT '.$s_coldefs['old']['fk_name'].', ';
            }
            $sql .= 'ADD';
            if (!empty($s_coldefs['mod']['fk_name'])) {
                $sql .= ' CONSTRAINT '.$s_coldefs['mod']['fk_name'];
            }
            $sql .= ' FOREIGN KEY ('.$s_coldefs['mod']['name'].')'
                   .' REFERENCES '.$s_coldefs['mod']['fk_table'].' ';
            if (isset($s_coldefs['mod']['fk_column'])  &&  $s_coldefs['mod']['fk_column'] != '') {
                $sql .= '('.$s_coldefs['mod']['fk_column'].') ';
            }
            if (isset($s_coldefs['mod']['on_update'])  &&  $s_coldefs['mod']['on_update'] != '') {
                $sql .= ' ON UPDATE '.$s_coldefs['mod']['on_update'];
            }
            if (isset($s_coldefs['mod']['on_delete'])  &&  $s_coldefs['mod']['on_delete'] != '') {
                $sql .= ' ON DELETE '.$s_coldefs['mod']['on_delete'].', ';
            }
            $mod_flag = TRUE;
        }
    }

    // build sql for altering column domain
    if ((isset($s_coldefs['mod']['domain'])  &&  $s_coldefs['mod']['domain'] == 'Yes')
    && $HTTP_POST_VARS['cd_def_domainmod'] != $s_coldefs['mod']['type']) {
        $s_coldefs['mod']['type']  = $HTTP_POST_VARS['cd_def_domainmod'];
        $sql .= 'ALTER '.$s_modify_col.' '.$s_coldefs['mod']['type'].', ';
        $mod_flag = TRUE;
    }

    // build sql for changing column position
    if ($HTTP_POST_VARS['tb_modcol_pos'] != '') {
        $sql .= 'ALTER '.$s_modify_col.' POSITION '.$HTTP_POST_VARS['tb_modcol_pos'].', ';
        $mod_flag = TRUE;
    }

    // build sql for renaming of the column
    if ($HTTP_POST_VARS['cd_def_namemod'] != $s_modify_col) {
        // interbase keywords are not allowed as column names     
        if (in_array(strtoupper($s_coldefs['mod']['name']), get_reserved_words(SERVER_FAMILY, SERVER_VERSION))) {
            $warning = sprintf($WARNINGS['NAME_IS_KEYWORD'], strtoupper($s_coldefs['mod']['name']));
        }
        else {
            $sql .= 'ALTER '.$s_modify_col.' TO '.$HTTP_POST_VARS['cd_def_namemod'].', ';
            $mod_flag = TRUE;
        }
    }

    if ($mod_flag) {
        $sql = substr($sql, 0, -2);      // remove the trailing ', '
        $sql .= ';';
    }
    else {
        $sql = '';
    }


    if ($s_watch_table == $s_modify_name) {
        $s_watch_buffer = '';
    }
}


//
// script is called from the delete table form
//
if (isset($HTTP_POST_VARS['tb_delete_doit'])
&&  isset ($HTTP_POST_VARS['tb_delete_name'])  &&  !empty($HTTP_POST_VARS['tb_delete_name'])) {

    $tname = $HTTP_POST_VARS['tb_delete_name'];

    $deps = get_dependencies(OT_RELATION, $tname);
    if (count($deps) > 0) {
        $message = sprintf($MESSAGES['HAVE_DEPENDENCIES'], $tb_strings['Table'], $tname, dependencies_string($deps));
    }

    else {
        $drop_statement = ($s_tables[$tname]['is_view'] == TRUE) ? 'DROP VIEW '.$tname : 'DROP TABLE '.$tname;
    
        if ($s_cust['askdel'] == TRUE) {
            $s_confirmations['table'] = 
                array('msg' => sprintf($MESSAGES['CONFIRM_TABLE_DELETE'], $tname),
                      'sql' => $drop_statement);
        }
        else {
            $sql = $drop_statement;
        }

        if ($s_modify_name == $HTTP_POST_VARS['tb_delete_name']) {
            $s_modify_name = '';
        }
        if ($s_watch_table == $HTTP_POST_VARS['tb_delete_name']) {
            $s_watch_table = '';
            $s_watch_buffer = '';
        }
        if ($s_enter_name == $HTTP_POST_VARS['tb_delete_name']) {
            $s_enter_name = '';
            $s_enter_values = array();
        }
    }
}


// 'Open All' button
if (isset($HTTP_POST_VARS['tb_table_open'])) {
    $s_tables = toggle_all_tables($s_tables, 'open');
}

// 'Close All' button
if (isset($HTTP_POST_VARS['tb_table_close'])) {
    $s_tables = toggle_all_tables($s_tables, 'close');
}


// deleting a subject is confirmed
if (isset($HTTP_POST_VARS['confirm_yes'])
&&  isset($s_confirmations[$HTTP_POST_VARS['confirm_subject']])) {

    $sql  = $s_confirmations[$HTTP_POST_VARS['confirm_subject']]['sql'];
    unset($s_confirmations[$HTTP_POST_VARS['confirm_subject']]);
}

// deleting a subject is canceled
if (isset($HTTP_POST_VARS['confirm_no'])
&&  isset($s_confirmations[$HTTP_POST_VARS['confirm_subject']])) {

    unset($s_confirmations[$HTTP_POST_VARS['confirm_subject']]);
}

// 
// perform the sql-statement in $sql
//
if ($sql != '') {
    if (DEBUG) add_debug('$sql: '.$sql, __FILE__, __LINE__);
    $trans = ibase_trans(TRANS_WRITE, $dbhandle);
    ibase_query($trans, $sql);
    if (ibase_commit($trans)) {
        $s_tables_valid = FALSE;		     
        $s_create_table = '';
        $s_create_num = 0;
        $s_coldefs = array();
        $s_modify_col = '';
    } else {
        $ib_error = ibase_errmsg();
        ibase_rollback($trans);
        if (isset($mod_flag)  &&  $mod_flag == TRUE) {
            $col_mod_flag = TRUE;
        }
        if (isset($add_flag) &&  $add_flag == TRUE) {
            $col_add_flag = TRUE;
        }
    }
}


$idx = get_panel_index($s_tables_panels, 'tb_show');
if ($s_tables_panels[$idx][2] == 'open' && $s_connected == TRUE) {

    // include the javascript for jsrs requests
    if ($s_use_jsrs == TRUE) {
        $js_stack .= js_jsrs_client();
        $js_stack .= js_jsrs_detail(); 
    }

    //
    // Reload button from the tb_show panel
    //
    if (isset($HTTP_POST_VARS['tb_show_reload'])) {

        $s_tables_counts = (isset($HTTP_POST_VARS['tb_show_counts'])) ? 'yes' : 'no';
        $s_tables_valid  = FALSE;
    }
}


// init $s_domain for the columns form if necessary
if ($s_domains_valid == FALSE  &&
    ($s_create_num > 0  ||  isset($col_add_flag))) {

    include_once('./inc/domains.inc.php');

    $s_domains = get_domain_definitions($s_domains);
    $s_domains_valid = TRUE;
}


// add javascript for the columns fomm
if (USE_DHTML === TRUE  &&  $s_connected === TRUE  && 
    ($s_create_num > 0  ||  isset($col_add_flag))) {

    $js_stack .= js_collations($s_charsets);

    if ($s_use_jsrs === TRUE) {
        $js_stack .= js_jsrs_table_columns();
    }
}


//
// setup $s_tables[] and $s_fields[] if necessary 
//
if (($s_connected) && ($s_tables_valid == FALSE)) {
	include_once('inc/get_tables.inc.php');
	if (get_tables($dbhandle)) {
	    $s_tables_valid = TRUE;
    }
}


//
// print out all the panels
//
$active = 'Tables';
$panels = &$s_tables_panels;
require('inc/script_end.inc.php');


//
// mark all tables as opened or closed in $s_tables
//
function &toggle_all_tables(&$tables, $status) {

    foreach (array_keys($tables) as $name) {
        if (!$tables[$name]['is_view']) {
            $tables[$name]['status'] = $status;
        }
    }

    return $tables;
}


function get_column_fk_defs($cname, $iname) {
    global $dbhandle;

    $defs = array('fk_name' => $cname);

    $trans = ibase_trans(TRANS_READ, $dbhandle);
    $sql = 'SELECT RDB$UPDATE_RULE,'
                .' RDB$DELETE_RULE'
           .' FROM RDB$REF_CONSTRAINTS'
          ." WHERE RDB\$CONSTRAINT_NAME='".$cname."'";
    $res = @ibase_query($trans, $sql) or ib_error(__FILE__, __LINE__, $sql);
    if ($res  && $row = ibase_fetch_row($res)) {
        ibase_free_result($res);
    }
    $defs['on_update'] = trim($row[0]);
    $defs['on_delete'] = trim($row[1]);

    $sql = 'SELECT I2.RDB$RELATION_NAME,'
                .' SE.RDB$FIELD_NAME'
           .' FROM RDB$INDICES I1'
     .' INNER JOIN RDB$INDICES I2 ON I1.RDB$FOREIGN_KEY=I2.RDB$INDEX_NAME'
     .' INNER JOIN RDB$INDEX_SEGMENTS SE ON I2.RDB$INDEX_NAME=SE.RDB$INDEX_NAME'
          ." WHERE I1.RDB\$INDEX_NAME='".$iname."'";
    $res = @ibase_query($trans, $sql) or ib_error(__FILE__, __LINE__, $sql);
    if ($res  && $row = ibase_fetch_row($res)) {
        ibase_free_result($res);
    }
    $defs['fk_table']  = trim($row[0]);
    $defs['fk_column'] = trim($row[1]);

    ibase_commit($trans);

    return $defs;
}

?>
