<?php
// File           move_panel.php / ibWebAdmin
// Purpose        change the position of a panel on his page
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <00/10/23 00:50:12 lb>
//
// $Id: move_panel.php,v 1.7 2004/02/07 15:21:34 lbrueckner Exp $

// Variables passed by URI:   $a       active menu item
//                            $p       index of panel to open/close
//                            $d       the string "up", "down", "top" or "bottom"


require('./inc/configuration.inc.php');
require('./inc/session.inc.php');
require('./inc/functions.inc.php');

session_start();
localize_session_vars();

require('./lang/' . (isset($s_cust) ? $s_cust['language'] : LANGUAGE) . '.inc.php');
require('./inc/array_functions.inc.php');


// some browsers may fail with the dynamically inserted html
if (!isset($HTTP_GET_VARS['p'])) {
    redirect(url_session($HTTP_SERVER_VARS['HTTP_REFERER']));
}


$pos = $HTTP_GET_VARS['p'];

//calculate the panel name
$pvar = 's_'.strtolower($HTTP_GET_VARS['a']).'_panels';

// change the order in the panel-array
switch ($HTTP_GET_VARS['d']) {
    case 'up':
        if ($pos > 0) {
            $$pvar = array_swap_elements($$pvar, $pos, $pos-1);
        }
        break;
   case 'down':
        if ($pos < count($$pvar) - 1) {
            $$pvar = array_swap_elements($$pvar, $pos, $pos+1);
        }
        break;
    case 'top':
        if ($pos != 0) {
            $$pvar = array_moveto_top($$pvar, $pos);
        }
        break;
    case 'bottom':
          if ($pos != count($$pvar) - 1) {
            $$pvar = array_moveto_end($$pvar, $pos);
        }
        break;
    default:
      die('move_panel.php was called with invalid parameters');
}

set_customize_cookie($s_cust);

globalize_session_vars();

// go back to where we come from
redirect(url_session($HTTP_SERVER_VARS['HTTP_REFERER']));

?>
