<?php
//
// jsrsServer.php - javascript remote scripting server include
//
// Orginal Author:  Brent Ashley [jsrs@megahuge.com]
// PHP version   :  Sbastien Cramatte [sebastien@webeclaireur.com] 
//		    Pierre Cailleux [cailleux@noos.fr]
// Date		 :  May 2001 
// 
// see jsrsClient.js for version info
//
// see license.txt for copyright and license info
//
// 2003-01-08    :  removed eval() calls, code cleanup
//                  Lutz Brueckner [irie@gmx.de]

// $Id: jsrsServer.php.inc,v 1.4 2003/08/25 20:50:36 lbrueckner Exp $


function jsrsDispatch($validFuncs ){

    $func = jsrsFunctionName($validFuncs);

    if ($func != '') {

        $parameters = jsrsParametersArray();
        $retval = call_user_func_array ($func, $parameters);

        is_string($retval) ? jsrsReturn($retval) : jsrsReturn('');
    }
    else {
        jsrsReturnError('function builds as empty string');
    }
}


function jsrsReturn($payload) {

    $C = jsrsRequestVariable('C');

    print ("<html><head></head><body onload=\"p=document.layers?parentLayer:window.parent;p.jsrsLoaded('" 
           . $C . "');\">jsrsPayload:<br>" 
           . "<form name=\"jsrs_Form\"><textarea name=\"jsrs_Payload\">"
           . jsrsEscape($payload) . "</textarea></form></body></html>");
    exit;
}


function jsrsEscape($str){

    // escape ampersands so special chars aren't interpreted
    // escape slashes  with whacks so end tags don't interfere with return html
    return str_replace(array('&', '/'), array('&amp;', '\/'), $str);
}


// answer the jsrs request with an error message
function jsrsReturnError($str){

    $C = jsrsRequestVariable('C');
  
    // escape quotes
    $cleanStr = str_replace(array("'", '"'), array("\\'", '\"'), $str);
  
    // !!!! --- Warning -- !!!
    print ('<html><head></head><body '
           . "onload=\"p=document.layers?parentLayer:window.parent;p.jsrsError('" . $C . "','" . urlencode($str) . "');\">"
           . 'jsrsError: ' . $cleanStr . '</body></html>');
    exit;
}


// get the name of the function which get called for generating the payload
//
// parameter:  $validFuncs  string with comma seperated list of function names
// result:     string       name of an existing php function
//                       or an empty string if the functions name is not 
//                          in $validFuncs or the function is undefined
function jsrsFunctionName($validFuncs) {

    $F = jsrsRequestVariable('F');

    if ($F !== FALSE) {
        $valids = explode(',', strtoupper(str_replace(' ', '', $validFuncs)));
        if (!in_array(strtoupper($F), $valids)  ||  !function_exists($F)) {
            jsrsReturnError($F . " is not a valid function" );
        }
    }

    return $F;
}


// get all parameter values submitted with the request
//
// result:   array    holding the values in the intented order
function jsrsParametersArray() {

    $parameters = array();

    $i = 0;
    while (${'P'.$i} = jsrsRequestVariable('P'.$i)) {
        $parameters[] = substr(${'P'.$i}, 1, -1);
        $i++;
    }

    return $parameters;
}


// get the value for a variable submitted by a post- or a get-request
//
// parameter:  $name    name for the variable of interest
// result:     string   representing the variables value
//         or  boolean  FALSE if no such request variable exists
function jsrsRequestVariable($name) {

    if (isset($_REQUEST[$name])) {
        return $_REQUEST[$name];
    }
    elseif (isset($GLOBALS['HTTP_POST_VARS'][$name])) {
        return $GLOBALS['HTTP_POST_VARS'][$name];
    }
    elseif (isset($GLOBALS['HTTP_GET_VARS'][$name])) {
        return $GLOBALS['HTTP_GET_VARS'][$name];
    }
    else {
        return FALSE;
    }
}


function jsrsArrayToString($a, $delim='~') {

    // user function to flatten 1-dim array to string for return to client
    return implode($a, $delim); 
}


// this get not called, I'm leaving this function for backward compatibility only
//
// parameter:  $validFuncs  string with comma seperated list of function names
// result:     string       a php function call, ready for eval() 
//                          or an empty string if the functions name is not in $validFuncs
function jsrsBuildFunc($validFuncs) {

    if (($func = jsrsFunctionName($validFuncs)) !== FALSE) {
        $parameters = jsrsParametersArray();
        $func .= (count($parameters) > 0) ? '("' . implode('", "', $parameters) . '")' : '()';
    }
    else {
        $func = '';
    }

    return $func;
}


// this really did not make any sense ...
function jsrsEvalEscape($thing) {
    $tmp = ereg_replace($thing,"\r\n","\n");
    return $tmp;
}

function jsrsVBArrayToString($a,$delim) {
    // --- not use in PHP see jsrsArrayToString method
    return jsrsArrayToString($a,$delim);
}

?>
