<?php
// File           inc/handle_editdata.inc.php / ibWebAdmin
// Purpose        provides the handling of the dt_edit-panel for sql.php and data.php
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003, 2004 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <01/04/16 16:19:48 lb>
//
// $Id: handle_editdata.inc.php,v 1.16 2004/03/31 20:06:07 lbrueckner Exp $


//
// check if and which 'done' or 'cancel' button on which dt_edit panel was clicked
//
foreach ($HTTP_POST_VARS as $name => $value) {
    if (preg_match('/dt_edit_(cancel|save)([0-9]+)/', $name, $matches)) {
        // index for array $s_edit_where[]
        $instance = $matches[2];
        $table = $s_edit_where[$instance]['table'];
        $job = $matches[1];
        $success = FALSE;

        if ($job == 'save') {

            // the origin types of domain-based columns are needed
            if (!$s_domains_valid) {

                include_once('./inc/domains.inc.php');

                $s_domains = get_domain_definitions($s_domains);
                $s_domains_valid = TRUE;
            }

            $s_edit_values[$instance] = array();
            $sql = "UPDATE $table SET ";
            $k = 1;
            foreach($s_fields as $field) {
                if ($field['table'] == $table) {

                    // skip computed columns
                    if (isset($field['comp'])) {
                        continue;
                    }

                    if (isset($HTTP_POST_FILES['dt_edit_field_'.$instance.'_'.$k])) {
                        $value = $HTTP_POST_FILES['dt_edit_field_'.$instance.'_'.$k];
                        $s_edit_values[$instance][] = $value['name'];
                    } else {
                        $value = get_request_data('dt_edit_field_'.$instance.'_'.$k);
                        $s_edit_values[$instance][] = $value;
                    }

                    // type of the field or the origin type of a domain-based field
                    $type = !isset($field['domain']) ? $field['type'] : $s_domains[$field['type']]['type'];

                    switch($type) {
                        case 'CHARACTER' :
                        case 'VARCHAR'   :
                            $value = str_replace("'", "''", $value);
                        case 'DATE'      :
                        case 'TIME'      :
                        case 'TIMESTAMP' :
                            $sql .= $field['name'].'=';
                            $sql .= (empty($field['notnull'])  &&  empty($value)) ? 'NULL, ' : "'$value', ";
                            break;
                        case 'BLOB' :
                            if (is_array($value)  &&  strlen(trim($value['name'])) > 0) {
                                $bfname = $value['tmp_name'];
                                $bfhandle = fopen($bfname, 'r') or die('cannot open file '.$bfname);
                                $bstr = ibase_blob_import($dbhandle, $bfhandle);
                                fclose($bfhandle);
                                $sql .= $field['name'].'=?, ';
                                $bindargs[] = $bstr;
                            }
                            elseif (isset($HTTP_POST_VARS['dt_drop_blob_'.$instance.'_'.$k])
                                    && empty($field['notnull'])) {
                                $sql .= $field['name'].'=NULL, ';
                            }
                            break;
                        default:
                            if ($value == '') {
                                $value = 'NULL';
                            }
                            $sql .= $field['name'].'='.$value.', ';
                    }
                }
                $k++;
            }

            $sql = substr($sql, 0, -2);
            $sql .= ' '.$s_edit_where[$instance]['where'];

            if (isset($bindargs)) {
                $n = count($bindargs); 
                $code = '$success = @ibase_query($dbhandle, $sql, ';
                for ($i=0; $i<$n; $i++) {
                    $code .= "\$bindargs[$i], ";
                }
                $code = substr($code, 0, -2).');';
                if (DEBUG) add_debug('$sql: '.$sql, __FILE__, __LINE__);
                if (DEBUG) add_debug('$code: '.$code, __FILE__, __LINE__);
                eval($code);
            }
            else {
                if (DEBUG) add_debug('$sql: '.$sql, __FILE__, __LINE__);
                $success = @ibase_query($dbhandle, $sql);
            }
            if (!$success) {
                $ib_error = ibase_errmsg();
            }

            // cleanup the watchtable output buffer
            $s_watch_buffer = '';
        }

        $panels_arrayname = get_panel_array($HTTP_SERVER_VARS['SCRIPT_NAME']);

        if ($success  ||  $job == 'cancel') {
            // remove the dt_edit panel
            $name = 'dt_edit'.$instance;
            $idx = get_panel_index($$panels_arrayname, $name);
            array_splice($$panels_arrayname, $idx, 1); 
            unset($s_edit_where[$instance]);
            unset($s_edit_values[$instance]);
            if (count($s_edit_where) == 0) {
                $s_edit_idx = 0;
            }
        }

        // save the values from other edit forms
        $notthis = $success  ||  $job == 'cancel' ? $instance : NULL;
        $s_edit_values = save_editform_values($notthis, $$panels_arrayname);
    }
}



// save the values from all edit forms beside the completed one
// into an array
function save_editform_values($notthis, $parray) {
    global $s_fields, $s_edit_where;
    global $HTTP_POST_FILES, $HTTP_POST_VARS;

    $values = array();
    foreach ($parray as $panel) {
        if (preg_match('/^dt_edit([0-9]+)/', $panel[0], $matches)  &&
            $matches[1] != $notthis) {

            $idx = $matches[1];
            $table = $s_edit_where[$idx]['table'];
            $k = 1;
            foreach($s_fields as $field) {
                if ($field['table'] == $table) {
                    if (isset($HTTP_POST_FILES['dt_edit_field_'.$idx.'_'.$k])) {
                        $values[$idx][] = $HTTP_POST_FILES['dt_edit_field_'.$idx.'_'.$k]['name'];
                    }
                    else {
                        $values[$idx][] = $HTTP_POST_VARS['dt_edit_field_'.$idx.'_'.$k];
                    }
                    $k++;
                }
            }
        }
    }

    return $values;
}


//
// output the form elements for editing a dataset
//
function data_edit($idx) {
    global $dbhandle, $s_edit_where, $s_fields;
    global $s_edit_values;

    $table = $s_edit_where[$idx]['table'];
    $where = $s_edit_where[$idx]['where'];

    // $s_edit_values[] is filled in handle_editdata.php with the values
    // from the postet edit forms
    if (!isset($s_edit_values[$idx])) {
        $sql = "SELECT * FROM $table $where";
        $res = ibase_query($dbhandle, $sql) or ib_error();
        if ($obj = ibase_fetch_object($res)) {
            $arr = get_object_vars($obj);
        }
        else {
            $arr = array();
            $GLOBALS['ib_error'] = "Query didn't return a result: ".$sql;
        }
        ibase_free_result($res);
    }

    $k = 1;
    foreach($s_fields as $field) {
        if ($field['table'] == $table) {
            if (isset($field['comp'])) {
                continue;
            }
            $maxlen = (isset($field['size'])) ? $field['size'] : 20;
            if (!isset($field['size'])) {
                $size = 20;
            }
            else {
                $size = ($field['size'] + 1  > DATA_MAXWIDTH) ? DATA_MAXWIDTH : $field['size'] + 1;
            }

            echo '<tr><td>'.$field['name']."</td>\n";
            $name = 'dt_edit_field_'.$idx.'_'.$k;

            if ($field['type'] != 'BLOB') {
                echo '<td><input type="text" size="'.$size.'" maxlength="'.$maxlen.'" name="'.$name.'" value="';
                if (isset($arr[$field['name']])) {
                    echo trim($arr[$field['name']]);
                }
                elseif (isset($s_edit_values[$idx][$k-1])){
                    echo $s_edit_values[$idx][$k-1];
                }
                echo "\">\n</td>\n";
            }

            else {  // $field['type'] == 'BLOB'
                if (isset($arr[$field['name']])) {
                    $url = url_session('showblob.php?where='.urlencode($where)."&table=$table&col=".$field['name']);

                    $blob_str = '<i><a href="'.$url.'" target="_blank"><b>BLOB</b></a>&nbsp;</i>';
                    $drop_str = '&nbsp;|&nbsp;<input type="checkbox" name="dt_drop_blob_'.$idx.'_'.$k.'">&nbsp;drop&nbsp;';
                    $size = 38;
                }
                else {
                    $blob_str = $drop_str = '';
                    $size = 50;
                }
                echo '<td>'.$blob_str.$drop_str.'<Input type="file" size="'.$size.'" name="'.$name."\" value=\"upload\">\n</td>\n";
            }
            echo "</tr>\n";
        }
        $k++;
    }
}

?>
