#!/usr/bin/env python
""" FPBench.py - Benchmark various performance characteristics of the FixedPoint module

    TestDefList is a list of TestDefs,

    A TestDef is a list = (Title, TestExpressionString, ReportString)

"""


LOOPCNT = 10000
VERBOSE = 0

import sys
from time import clock

from fixedpoint import FixedPoint, bankersRounding
FixedPoint.round = bankersRounding

def run_test(TestDef, Loops=LOOPCNT):
    rTitle, TestExpStr, TestReport = TestDef
    tstExec = compile(TestExpStr,'<Test Expression>','eval')
    for i in range(Loops):
        eval(tstExec)
		    
NullTest=("Null Time", "123.123","Null Time (%i execs of floating point): %7.5f secs. (%8.3f ops/sec.)")
if VERBOSE: print "Starting: ", NullTest[0]
start_time = clock()
run_test(NullTest)
nulltime = clock() - start_time
print NullTest[2] % (LOOPCNT,nulltime, LOOPCNT/nulltime)
    

TestDefList = (
# ("Null Time", "123.123","Null Time (%i execs of floating point): %7.5f secs."),
 ("FP Allocation Test 1",'FixedPoint("1.0",2)',"FixedPoint Allocation of %i objects (from string - 2 decimal places): %7.5f"),
 ("FP Allocation Test 2",'FixedPoint("1.0",20)',"FixedPoint Allocation of %i objects (from string - 20 decimal places): %7.5f"),
 ("FP Allocation Test 3",'FixedPoint(3,2)',"FixedPoint Allocation of %i objects (from integer - 2 decimal places): %7.5f"),
 ("FP Allocation Test 4",'FixedPoint(3,20)',"FixedPoint Allocation of %i objects (from integer - 20 decimal places): %7.5f"),
 ("FP Allocation Test 5",'FixedPoint("123456789123456789.0",20)',"FixedPoint Allocation of %i objects (20 decimal places-large values): %7.5f"),
 ("FP MUL Test 1",'FixedPoint("2.1")*2.1',"FixedPointPoint(p=2) mul of float (%i times): %7.5f"),
 ("FP MUL Test 2",'FixedPoint("2.1",20)*2.1',"FixedPointPoint(p=20) mul of float (%i times): %7.5f"),
 ("FP MUL Test 3",'FixedPoint("2.1")*3',"FixedPointPoint(p=2) mul of int (%i times): %7.5f"),
 ("FP MUL Test 4",'FixedPoint("2.1",20)*3',"FixedPointPoint(p=20) mul of int (%i times): %7.5f"),
 ("FP MUL Test 5",'FixedPoint("2.1")*FixedPoint("3.2")',"FixedPointPoint(p=2) mul of 2 FixedPoints (%i times): %7.5f"),
 ("FP MUL Test 6",'FixedPoint("2.1",20)*FixedPoint("3.2",20)',"FixedPointPoint(p=20) mul of 2 FixedPoints (%i times): %7.5f"),
 ("FP MUL Test 7",'FixedPoint("2.1",2)*FixedPoint("3.2",20)',"FixedPointPoint(p=2/20) mul of 2 FixedPoints (%i times): %7.5f")

) #end of TestDefList

for testdef in TestDefList:
    if VERBOSE: print 'Starting: %s' % testdef[0]
    start_time = clock()
    run_test(testdef)
    test_time = clock() - start_time - nulltime
    print testdef[2] % (LOOPCNT, test_time),
    try:
        print "(%8.3f ops/sec.)" % (LOOPCNT/test_time,)
    except ZeroDivisionError:
        print "(N/A ops/sec.)"


