/*
* JBoss, Home of Professional Open Source
* Copyright 2005, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.test.remoting.transport.multiplex.config;

import java.util.HashMap;
import java.util.Map;

import javax.management.MBeanServer;

import junit.framework.TestCase;

import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvocationRequest;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.ServerInvocationHandler;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.HandleCallbackException;
import org.jboss.remoting.callback.InvokerCallbackHandler;
import org.jboss.remoting.transport.Connector;
import org.jboss.remoting.transport.PortUtil;
import org.jboss.remoting.transport.multiplex.Multiplex;
import org.apache.log4j.Level;

/**
 * @author <a href="mailto:tim.fox@jboss.com">Tim Fox</a>
 *
 */
public class MultiplexTest extends TestCase
{
   // Constants -----------------------------------------------------

   private static final Logger log = Logger.getLogger(MultiplexTest.class);


   // Static --------------------------------------------------------

   // Attributes ----------------------------------------------------

   // Constructors --------------------------------------------------

   public MultiplexTest(String name)
   {
      super(name);
   }

   // TestCase overrides -------------------------------------------

   public void setUp() throws Exception
   {

      super.setUp();

   }

   public void tearDown() throws Exception
   {

      super.tearDown();
   }

   public void testNothing()
   {

   }

   public void testConnectionsRemainOpen() throws Throwable
   {
      org.apache.log4j.BasicConfigurator.configure();
//      org.apache.log4j.Category.getRoot().setLevel(Level.INFO);

      //Start a server

      Connector serverConnector = new Connector();
      InvokerLocator serverLocator = new InvokerLocator("multiplex://localhost:9099");
      serverConnector.setInvokerLocator(serverLocator.getLocatorURI());
      serverConnector.create();
      SimpleServerInvocationHandler invocationHandler = new SimpleServerInvocationHandler();
      serverConnector.addInvocationHandler("JMS", invocationHandler);
      serverConnector.start();

      log.info("Server started");

      for (int i = 0; i < 1000; i++)
      {
         System.out.println("round: " + i);
         //Create a client for invoking on the server:
         int localPort = PortUtil.findFreePort("localhost");

         log.info("Free port is:" + localPort);
         System.out.println("Free port is:" + localPort);

         String locatorURI =
            "multiplex://localhost:9099";

         InvokerLocator locatorClient = new InvokerLocator(locatorURI);
         Map configuration = new HashMap();
//         configuration.put(Multiplex.CLIENT_MULTIPLEX_ID_KEY, "" + i);
         configuration.put(Multiplex.CLIENT_MULTIPLEX_ID, "mytestid");
         configuration.put(Multiplex.MULTIPLEX_BIND_HOST, "localhost");
         configuration.put(Multiplex.MULTIPLEX_BIND_PORT, String.valueOf(localPort));

         Client client = new Client(locatorClient, configuration);

         log.info("Created client");

         client.connect();

         log.info("Invoking");

         String response = (String)client.invoke("Cheese");

         log.info("Invocation completed");

         assertNotNull(response);
         assertEquals("Sausages", response);
//
//         Connector callbackServerConnector = new Connector();
//
////         InvokerLocator callbackServerLocator = new InvokerLocator("multiplex://localhost:" + localPort + "/?serverMultiplexId=" + i);
//         InvokerLocator callbackServerLocator = new InvokerLocator("multiplex://localhost:" + localPort + "/?serverMultiplexId=mytestid");
//
//         callbackServerConnector.setInvokerLocator(callbackServerLocator.getLocatorURI());
//         callbackServerConnector.create();
//         callbackServerConnector.start();

         configuration.clear();
         configuration.put(Multiplex.MULTIPLEX_CONNECT_HOST, "localhost");
         configuration.put(Multiplex.MULTIPLEX_CONNECT_PORT, "9099");
         Connector callbackServerConnector = new Connector("multiplex://localhost:" + localPort, configuration);
         callbackServerConnector.create();
         callbackServerConnector.start();
         
         log.info("Created callback server");


         log.info("Invoking");

         response = (String)client.invoke("Cheese");

         log.info("Invocation completed");

         assertNotNull(response);
         assertEquals("Sausages", response);

         SimpleCallbackHandler callbackHandler = new SimpleCallbackHandler();
InvokerLocator callbackServerLocator = new InvokerLocator("multiplex://localhost:" + localPort);
         client.addListener(callbackHandler, callbackServerLocator);

         assertNotNull(invocationHandler.handler);

         Callback cb = new Callback("Squirrel");

         invocationHandler.handler.handleCallback(cb);

         assertNotNull(callbackHandler.callback);
         assertEquals("Squirrel", callbackHandler.callback.getParameter());

         client.removeListener(callbackHandler);
         callbackServerConnector.stop();

         client.disconnect();

      }

      System.out.println("\n\n*** Done with test ***");

      serverConnector.stop();
      serverConnector.destroy();

      Thread.sleep(1000 * 60 * 30);

      //Now run netstat -a and see how many TCP connections are open!

   }

   class SimpleCallbackHandler implements InvokerCallbackHandler
   {

      Callback callback;

      public void handleCallback(Callback callback) throws HandleCallbackException
      {
         this.callback = callback;
      }

   }

   class SimpleServerInvocationHandler implements ServerInvocationHandler
   {
      InvokerCallbackHandler handler;


      public void addListener(InvokerCallbackHandler callbackHandler)
      {
         this.handler = callbackHandler;

      }

      public Object invoke(InvocationRequest invocation) throws Throwable
      {
         log.info("Received invocation:" + invocation);

         return "Sausages";
      }

      public void removeListener(InvokerCallbackHandler callbackHandler)
      {
         // FIXME removeListener

      }

      public void setInvoker(ServerInvoker invoker)
      {
         // FIXME setInvoker

      }

      public void setMBeanServer(MBeanServer server)
      {
         // FIXME setMBeanServer

      }

   }

}

